/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.implementation.multiblocks;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import me.justahuman.spiritsunchained.implementation.multiblocks.ChargedCore;
import me.justahuman.spiritsunchained.slimefun.Groups;
import me.justahuman.spiritsunchained.slimefun.ItemStacks;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class Tier2Altar
extends SlimefunItem {
    private static final Map<Vector, Material> blocks = new LinkedHashMap<Vector, Material>();
    private static final String complete = "complete";

    public Tier2Altar() {
        super((ItemGroup)Groups.SU_ALTAR_2, ItemStacks.SU_CHARGED_CORE_II, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{null, ItemStacks.SU_CHARGED_QUARTZ_II, null, ItemStacks.SU_CHARGED_QUARTZ_II, null, ItemStacks.SU_CHARGED_QUARTZ_II, null, ItemStacks.SU_CHARGED_QUARTZ_II, null});
        blocks.put(new Vector(2, 0, -2), Material.QUARTZ_PILLAR);
        blocks.put(new Vector(1, 0, -1), Material.QUARTZ_BLOCK);
        blocks.put(new Vector(1, 0, 0), Material.QUARTZ_STAIRS);
        blocks.put(new Vector(1, 0, 1), Material.QUARTZ_BLOCK);
        blocks.put(new Vector(2, 0, 2), Material.QUARTZ_PILLAR);
        blocks.put(new Vector(0, 0, -1), Material.QUARTZ_STAIRS);
        blocks.put(new Vector(0, 0, 0), Material.CHISELED_QUARTZ_BLOCK);
        blocks.put(new Vector(0, 0, 1), Material.QUARTZ_STAIRS);
        blocks.put(new Vector(-2, 0, -2), Material.QUARTZ_PILLAR);
        blocks.put(new Vector(-1, 0, -1), Material.QUARTZ_BLOCK);
        blocks.put(new Vector(-1, 0, 0), Material.QUARTZ_STAIRS);
        blocks.put(new Vector(-1, 0, 1), Material.QUARTZ_BLOCK);
        blocks.put(new Vector(-2, 0, 2), Material.QUARTZ_PILLAR);
        blocks.put(new Vector(2, 1, -2), Material.QUARTZ_PILLAR);
        blocks.put(new Vector(2, 1, 2), Material.QUARTZ_PILLAR);
        blocks.put(new Vector(-2, 1, -2), Material.QUARTZ_PILLAR);
        blocks.put(new Vector(-2, 1, 2), Material.QUARTZ_PILLAR);
        blocks.put(new Vector(2, 2, -2), Material.QUARTZ_STAIRS);
        blocks.put(new Vector(2, 2, 2), Material.QUARTZ_STAIRS);
        blocks.put(new Vector(-2, 2, -2), Material.QUARTZ_STAIRS);
        blocks.put(new Vector(-2, 2, 2), Material.QUARTZ_STAIRS);
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public boolean isSynchronized() {
                return true;
            }

            public void tick(Block block, SlimefunItem slimefunItem, Config config) {
                ChargedCore.tick(block);
            }
        }});
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{this.onPlace(), this.onUse(), this.onBreak()});
    }

    private BlockPlaceHandler onPlace() {
        return new BlockPlaceHandler(false){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent event) {
                Block block = event.getBlockPlaced();
                BlockStorage.addBlockInfo((Block)block, (String)"particle", (String)"4");
                BlockStorage.addBlockInfo((Block)block, (String)"multiplier", (String)"2.0");
                if (Tier2Altar.this.isComplete(block)) {
                    BlockStorage.addBlockInfo((Block)block, (String)Tier2Altar.complete, (String)"true");
                    event.getPlayer().sendMessage(SpiritUtils.getTranslation("messages.altar.completed.2"));
                } else {
                    BlockStorage.addBlockInfo((Block)block, (String)Tier2Altar.complete, (String)"false");
                    event.getPlayer().sendMessage(SpiritUtils.getTranslation("messages.altar.complete_prompt"));
                }
            }
        };
    }

    private BlockUseHandler onUse() {
        return event -> {
            Block block;
            Block block2 = block = event.getClickedBlock().isPresent() ? (Block)event.getClickedBlock().get() : null;
            if (block != null && BlockStorage.getLocationInfo((Location)block.getLocation(), (String)complete).equals("false")) {
                if (this.isComplete(block)) {
                    BlockStorage.addBlockInfo((Block)block, (String)complete, (String)"true");
                    event.getPlayer().sendMessage(SpiritUtils.getTranslation("messages.altar.completed.2"));
                } else {
                    BlockStorage.addBlockInfo((Block)block, (String)complete, (String)"false");
                    event.getPlayer().sendMessage(SpiritUtils.getTranslation("messages.altar.not_completed"));
                }
            }
            event.cancel();
        };
    }

    private BlockBreakHandler onBreak() {
        return new BlockBreakHandler(false, false){

            public void onPlayerBreak(@Nonnull BlockBreakEvent event, @Nonnull ItemStack item, @Nonnull List<ItemStack> drops) {
                BlockStorage.addBlockInfo((Block)event.getBlock(), (String)Tier2Altar.complete, null);
                BlockStorage.clearBlockInfo((Block)event.getBlock());
                event.getPlayer().sendMessage(SpiritUtils.getTranslation("messages.altar.broken"));
            }
        };
    }

    private boolean isComplete(@Nonnull Block block) {
        for (Map.Entry<Vector, Material> entry : blocks.entrySet()) {
            Vector relative = entry.getKey();
            Material relativeMaterial = entry.getValue();
            Block relativeBlock = block.getRelative(relative.getBlockX(), relative.getBlockY(), relative.getBlockZ());
            if (relativeBlock.getType() == relativeMaterial && this.isAltarPiece(relativeBlock)) continue;
            return false;
        }
        return true;
    }

    private boolean isAltarPiece(@Nonnull Block block) {
        if (BlockStorage.getLocationInfo((Location)block.getLocation(), (String)"id") == null) {
            return false;
        }
        return switch (BlockStorage.getLocationInfo((Location)block.getLocation(), (String)"id")) {
            case "SU_CHARGED_QUARTZ_II", "SU_CHARGED_STAIRS_II", "SU_CHARGED_PILLAR_II", "SU_CHARGED_CORE_II" -> true;
            default -> false;
        };
    }

    public static Map<Vector, Material> getBlocks() {
        return blocks;
    }
}

