/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.managers;

import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.justahuman.spiritsunchained.SpiritsUnchained;
import me.justahuman.spiritsunchained.implementation.mobs.AbstractCustomMob;
import me.justahuman.spiritsunchained.implementation.multiblocks.Tier1Altar;
import me.justahuman.spiritsunchained.implementation.multiblocks.Tier2Altar;
import me.justahuman.spiritsunchained.implementation.multiblocks.Tier3Altar;
import me.justahuman.spiritsunchained.utils.Keys;
import me.justahuman.spiritsunchained.utils.ParticleUtils;
import me.justahuman.spiritsunchained.utils.PlayerUtils;
import me.justahuman.spiritsunchained.utils.SpiritTraits;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class CommandManager
implements TabExecutor {
    public final Set<String> spiritTypes;
    public final List<String> entityTypes;
    public final Set<UUID> ghostBlocks;

    public CommandManager() {
        this.spiritTypes = SpiritsUnchained.getSpiritEntityManager().entityMap.keySet();
        this.entityTypes = SpiritUtils.getTypes();
        this.ghostBlocks = new HashSet<UUID>();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        Player player;
        block10: {
            block9: {
                if (!(sender instanceof Player)) break block9;
                player = (Player)sender;
                if (args.length != 0) break block10;
            }
            return false;
        }
        if (this.useCommand("TestParticles", player, 2, args)) {
            return this.testParticles(player, args[1]);
        }
        if (this.useCommand("SummonSpirit", player, 2, args)) {
            return this.summonSpirit(args[1], player, args.length >= 3 ? args[2] : "COW");
        }
        if (this.useCommand("GiveSpirit", player, 2, args)) {
            return this.giveSpirit(player, args[1], args.length >= 3 ? args[2] : "Friendly");
        }
        if (this.useCommand("EditItem", player, 2, args)) {
            return this.editItem(player, args[1], args.length >= 3 ? args[2] : "Blank");
        }
        if (this.useCommand("ResetCooldowns", player, 1, args)) {
            return this.resetCooldown(player, args.length >= 2 ? args[1] : player.getName());
        }
        if (this.useCommand("Altar", player, 2, args)) {
            return this.visualizeAltar(player, args[1]);
        }
        return false;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        Player player;
        block33: {
            block32: {
                if (!(sender instanceof Player)) break block32;
                player = (Player)sender;
                if (args.length != 0) break block33;
            }
            return new ArrayList<String>();
        }
        if (command.getName().equalsIgnoreCase("spirits")) {
            ArrayList<String> l = new ArrayList<String>();
            HashMap<String, Integer> add = new HashMap<String, Integer>();
            if (args.length == 1) {
                add.put("Altar", 0);
                add.put("TestParticles", 0);
                add.put("GiveSpirit", 0);
                add.put("SummonSpirit", 0);
                add.put("EditItem", 0);
                add.put("ResetCooldowns", 0);
            } else if (args.length == 2) {
                if (args[0].equalsIgnoreCase("TestParticles")) {
                    add.put("Catch", 1);
                    add.put("Bottle", 1);
                    add.put("PassOn", 1);
                } else if (args[0].equalsIgnoreCase("Altar")) {
                    add.put("1", 1);
                    add.put("2", 1);
                    add.put("3", 1);
                } else if (args[0].equalsIgnoreCase("SummonSpirit")) {
                    for (String string : this.spiritTypes) {
                        add.put(string, 1);
                    }
                } else if (args[0].equalsIgnoreCase("GiveSpirit")) {
                    for (String string : this.entityTypes) {
                        add.put(string, 1);
                    }
                } else if (args[0].equalsIgnoreCase("EditItem")) {
                    add.put("State", 1);
                    add.put("Progress", 1);
                    add.put("Max", 1);
                } else if (args[0].equalsIgnoreCase("ResetCooldowns")) {
                    for (Player player2 : Bukkit.getOnlinePlayers()) {
                        add.put(player2.getName(), 1);
                    }
                }
            } else if (args.length == 3) {
                if (args[0].equalsIgnoreCase("SummonSpirit") && args[1].equalsIgnoreCase("UNIDENTIFIED_SPIRIT")) {
                    for (EntityType entityType : SpiritsUnchained.getSpiritsManager().getSpiritMap().keySet()) {
                        add.put(String.valueOf(entityType), 2);
                    }
                } else if (args[0].equalsIgnoreCase("EditItem") && args[1].equalsIgnoreCase("State") || args[0].equalsIgnoreCase("GiveSpirit") && this.entityTypes.contains(args[1])) {
                    for (String string : SpiritUtils.getStates()) {
                        add.put(string, 2);
                    }
                } else if (args[0].equalsIgnoreCase("EditItem") && args[1].equalsIgnoreCase("Progress")) {
                    add.put("1", 2);
                    add.put("10", 2);
                    add.put("25", 2);
                    add.put("50", 2);
                    add.put("75", 2);
                    add.put("100", 2);
                }
            }
            for (Map.Entry entry : add.entrySet()) {
                String toAdd = (String)entry.getKey();
                Integer index = (Integer)entry.getValue();
                if (!toAdd.toLowerCase().contains(args[index].toLowerCase()) || index == 0 && !this.hasPerm(player, toAdd)) continue;
                l.add(toAdd);
            }
            return l;
        }
        return Collections.emptyList();
    }

    private boolean useCommand(String command, Player player, int size, String[] args) {
        return args[0].equalsIgnoreCase(command) && args.length >= size && this.hasPerm(player, command);
    }

    private boolean hasPerm(Player player, String command) {
        return player.isOp() || player.hasPermission("spiritsunchained.*") || player.hasPermission("spiritsunchained." + command.toLowerCase());
    }

    private boolean visualizeAltar(Player player, String altar) {
        Location location = player.getLocation();
        World world = player.getWorld();
        if (!(altar.equals("1") || altar.equals("2") || altar.equals("3"))) {
            return this.sendError(player, "altar.error.altar_tier");
        }
        if (PersistentDataAPI.hasLong((PersistentDataHolder)player, (NamespacedKey)Keys.visualizing) && PersistentDataAPI.getLong((PersistentDataHolder)player, (NamespacedKey)Keys.visualizing) > System.currentTimeMillis()) {
            return this.sendError(player, "altar.error.altar_multiple");
        }
        PersistentDataAPI.setLong((PersistentDataHolder)player, (NamespacedKey)Keys.visualizing, (long)(System.currentTimeMillis() + 30000L));
        Map<Vector, Material> altarMap = switch (altar) {
            case "3" -> Tier3Altar.getBlocks();
            case "2" -> Tier2Altar.getBlocks();
            default -> Tier1Altar.getBlocks();
        };
        player.sendMessage(SpiritUtils.getTranslation("messages.commands.altar.use").replace("{altar_tier}", altar));
        player.sendMessage(SpiritUtils.getTranslation("messages.commands.altar.materials"));
        HashSet<Material> sent = new HashSet<Material>();
        for (Material material : altarMap.values()) {
            if (sent.contains(material)) continue;
            sent.add(material);
            String tier = switch (altar) {
                case "3" -> " III";
                case "2" -> " II";
                default -> " I";
            };
            String slimefunVersion = ChatUtils.humanize((String)material.name()).replace("Chiseled Quartz", "Charged Core").replace("Quartz", "Charged Quartz").replace("Block", "") + tier;
            player.sendMessage(ChatColors.color((String)("&6" + Collections.frequency(altarMap.values(), material) + " &e" + slimefunVersion)));
        }
        int entryIndex = 0;
        for (Map.Entry<Vector, Material> entry : altarMap.entrySet()) {
            int finalEntryIndex = entryIndex;
            Bukkit.getScheduler().runTaskLater((Plugin)SpiritsUnchained.getInstance(), () -> {
                Vector changes = (Vector)entry.getKey();
                Location relativeLocation = new Location(location.getWorld(), (double)location.getBlockX() + 0.5, (double)location.getBlockY(), (double)location.getBlockZ() + 0.5).add(changes);
                BlockData blockData = ((Material)entry.getValue()).createBlockData();
                if (blockData instanceof Directional) {
                    Directional directional = (Directional)blockData;
                    BlockFace face = Math.max(Math.abs(changes.getX()), Math.abs(changes.getZ())) == Math.abs(changes.getX()) ? (changes.getX() > 0.0 ? BlockFace.WEST : BlockFace.EAST) : (changes.getZ() > 0.0 ? BlockFace.NORTH : BlockFace.SOUTH);
                    directional.setFacing(face);
                }
                FallingBlock fallingBlock = world.spawnFallingBlock(relativeLocation, blockData);
                this.ghostBlocks.add(fallingBlock.getUniqueId());
                fallingBlock.setVelocity(new Vector(0, 0, 0));
                fallingBlock.setGravity(false);
                fallingBlock.setDropItem(false);
                fallingBlock.setPersistent(true);
                fallingBlock.setInvulnerable(true);
                PersistentDataAPI.setString((PersistentDataHolder)fallingBlock, (NamespacedKey)Keys.entityKey, (String)"altar");
                Bukkit.getScheduler().runTaskLater((Plugin)SpiritsUnchained.getInstance(), () -> {
                    if (fallingBlock != null) {
                        this.ghostBlocks.remove(fallingBlock.getUniqueId());
                        fallingBlock.remove();
                    }
                }, 600L - (long)finalEntryIndex * 5L);
            }, (long)entryIndex * 5L);
            ++entryIndex;
        }
        return true;
    }

    private boolean testParticles(Player player, String test) {
        Location location = player.getLocation();
        switch (test.toLowerCase()) {
            case "catch": {
                ParticleUtils.catchAnimation(location);
                break;
            }
            case "bottle": {
                ParticleUtils.bottleAnimation(location);
                break;
            }
            case "passon": {
                ParticleUtils.passOnAnimation(location);
                break;
            }
            default: {
                this.sendError(player, "particles.error");
            }
        }
        return true;
    }

    private boolean giveSpirit(Player player, String type, String state) {
        EntityType spiritType;
        try {
            spiritType = EntityType.valueOf((String)type);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return this.sendError(player, "give_spirit.error");
        }
        ItemStack spirit = SpiritUtils.spiritItem(state, SpiritsUnchained.getSpiritsManager().getSpiritMap().get(spiritType));
        SpiritUtils.updateSpiritItemProgress(spirit, 100.0);
        PlayerUtils.addOrDropItem(player, SpiritUtils.spiritItem(state, SpiritsUnchained.getSpiritsManager().getSpiritMap().get(spiritType)));
        return true;
    }

    private boolean summonSpirit(String spiritId, Player player, String type) {
        AbstractCustomMob<?> spirit = SpiritsUnchained.getSpiritEntityManager().getCustomClass(null, spiritId);
        if (spirit == null || !SpiritUtils.canSpawn()) {
            return this.sendError(player, "summon_spirit.error");
        }
        spirit.spawn(player.getLocation(), player.getWorld(), "Natural", type);
        return true;
    }

    private boolean editItem(Player player, String toChange, String changeValue) {
        ItemStack item = player.getInventory().getItemInMainHand();
        if (!SpiritUtils.isSpiritItem(item)) {
            return this.sendError(player, "edit_item.error.not_holding");
        }
        ItemMeta meta = item.getItemMeta();
        if (toChange.equalsIgnoreCase("state")) {
            if (!SpiritUtils.getStates().contains(changeValue)) {
                return this.sendError(player, "edit_item.error.wrong_state");
            }
            PersistentDataAPI.setString((PersistentDataHolder)meta, (NamespacedKey)Keys.spiritStateKey, (String)changeValue);
        } else if (toChange.equalsIgnoreCase("progress")) {
            try {
                PersistentDataAPI.setDouble((PersistentDataHolder)meta, (NamespacedKey)Keys.spiritProgressKey, (double)Double.parseDouble(changeValue));
            }
            catch (NullPointerException | NumberFormatException e) {
                return this.sendError(player, "edit_item.error.wrong_progress");
            }
        } else if (toChange.equalsIgnoreCase("max")) {
            PersistentDataAPI.setString((PersistentDataHolder)meta, (NamespacedKey)Keys.spiritStateKey, (String)"Friendly");
            PersistentDataAPI.setDouble((PersistentDataHolder)meta, (NamespacedKey)Keys.spiritProgressKey, (double)100.0);
        }
        item.setItemMeta(meta);
        SpiritUtils.updateSpiritItemProgress(item, 0.0);
        return true;
    }

    private boolean resetCooldown(Player sender, String playerName) {
        Player player = Bukkit.getPlayer((String)playerName);
        if (player == null) {
            return this.sendError(sender, "reset_cooldown.error");
        }
        SpiritTraits.resetCooldown(player);
        return true;
    }

    private boolean sendError(Player player, String path) {
        player.sendMessage(SpiritUtils.getTranslation("messages.commands." + path));
        return true;
    }
}

