/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.utils;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.StringUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.justahuman.spiritsunchained.SpiritsUnchained;
import me.justahuman.spiritsunchained.managers.ConfigManager;
import me.justahuman.spiritsunchained.managers.SpiritEntityManager;
import me.justahuman.spiritsunchained.managers.SpiritsManager;
import me.justahuman.spiritsunchained.runnables.RelationsAndStateRunnable;
import me.justahuman.spiritsunchained.slimefun.ItemStacks;
import me.justahuman.spiritsunchained.spirits.SpiritDefinition;
import me.justahuman.spiritsunchained.utils.Keys;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.util.Vector;

public class SpiritUtils {
    public static final Map<Integer, Entity> spiritIdMap = new HashMap<Integer, Entity>();
    private static final ConfigManager configManager = SpiritsUnchained.getConfigManager();
    private static final SpiritEntityManager spiritEntityManager = SpiritsUnchained.getSpiritEntityManager();
    private static final SpiritsManager spiritsManager = SpiritsUnchained.getSpiritsManager();
    private static final Map<EntityType, SpiritDefinition> spiritMap = spiritsManager.getSpiritMap();
    private static final SpiritsUnchained instance = SpiritsUnchained.getInstance();
    private static final FileConfiguration config = instance.getConfig();

    public static String getTranslation(String path) {
        return configManager.getTranslation(path);
    }

    public static List<String> getTranslationList(String path) {
        return configManager.getTranslationList(path);
    }

    public static List<String> getStates() {
        ArrayList<String> states = new ArrayList<String>();
        states.add("Hostile");
        states.add("Aggressive");
        states.add("Passive");
        states.add("Gentle");
        states.add("Friendly");
        return states;
    }

    public static List<String> getTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (EntityType type : spiritMap.keySet()) {
            types.add(type.name());
        }
        return types;
    }

    public static ChatColor tierColor(int tier) {
        return switch (tier) {
            case 2 -> ChatColor.AQUA;
            case 3 -> ChatColor.LIGHT_PURPLE;
            case 4 -> ChatColor.GOLD;
            default -> ChatColor.YELLOW;
        };
    }

    public static ChatColor stateColor(String state) {
        return switch (state) {
            case "Hostile" -> ChatColor.DARK_RED;
            case "Aggressive" -> ChatColor.RED;
            case "Gentle" -> ChatColor.GREEN;
            case "Friendly" -> ChatColor.DARK_GREEN;
            default -> ChatColor.YELLOW;
        };
    }

    @ParametersAreNonnullByDefault
    public static FireworkEffect effectColor(EntityType type) {
        return switch (type) {
            case EntityType.AXOLOTL -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)235, (int)181, (int)213)).build();
            case EntityType.BAT -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)64, (int)53, (int)41)).build();
            case EntityType.BEE, EntityType.PUFFERFISH -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)228, (int)165, (int)1)).build();
            case EntityType.BLAZE -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)231, (int)167, (int)1)).build();
            case EntityType.CAT -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)221, (int)185, (int)131)).build();
            case EntityType.CAVE_SPIDER -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)11, (int)61, (int)72)).build();
            case EntityType.CHICKEN -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)149, (int)149, (int)149)).build();
            case EntityType.COD -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)164, (int)142, (int)90)).build();
            case EntityType.COW -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)63, (int)50, (int)35)).build();
            case EntityType.CREEPER -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)12, (int)157, (int)10)).build();
            case EntityType.DOLPHIN -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)32, (int)55, (int)72)).build();
            case EntityType.DONKEY -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)78, (int)65, (int)53)).build();
            case EntityType.DROWNED -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)132, (int)223, (int)199)).build();
            case EntityType.ELDER_GUARDIAN -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)193, (int)191, (int)174)).build();
            case EntityType.ENDERMAN, EntityType.ENDERMITE, EntityType.ENDER_DRAGON -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)20, (int)20, (int)20)).build();
            case EntityType.EVOKER -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)138, (int)144, (int)144)).build();
            case EntityType.FOX -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)197, (int)169, (int)147)).build();
            case EntityType.FROG -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)195, (int)109, (int)64)).build();
            case EntityType.GHAST -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)234, (int)234, (int)234)).build();
            case EntityType.GLOW_SQUID -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)8, (int)80, (int)80)).build();
            case EntityType.GOAT -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)155, (int)139, (int)116)).build();
            case EntityType.GUARDIAN -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)83, (int)120, (int)106)).build();
            case EntityType.HOGLIN -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)186, (int)103, (int)80)).build();
            case EntityType.HORSE -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)183, (int)151, (int)119)).build();
            case EntityType.HUSK -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)112, (int)104, (int)90)).build();
            case EntityType.LLAMA -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)180, (int)148, (int)117)).build();
            case EntityType.MAGMA_CUBE -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)49, (int)0, (int)0)).build();
            case EntityType.MUSHROOM_COW -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)150, (int)14, (int)15)).build();
            case EntityType.MULE -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)25, (int)2, (int)0)).build();
            case EntityType.OCELOT -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)221, (int)206, (int)116)).build();
            case EntityType.PANDA, EntityType.SHEEP, EntityType.TURTLE, EntityType.IRON_GOLEM, EntityType.SNOWMAN -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)217, (int)217, (int)217)).build();
            case EntityType.PARROT -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)12, (int)157, (int)10)).build();
            case EntityType.PHANTOM -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)63, (int)76, (int)129)).build();
            case EntityType.PIG -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)225, (int)155, (int)152)).build();
            case EntityType.PIGLIN -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)143, (int)89, (int)60)).build();
            case EntityType.PIGLIN_BRUTE -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)83, (int)39, (int)15)).build();
            case EntityType.PILLAGER -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)78, (int)44, (int)51)).build();
            case EntityType.POLAR_BEAR -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)224, (int)224, (int)224)).build();
            case EntityType.RABBIT -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)143, (int)89, (int)60)).build();
            case EntityType.RAVAGER -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)108, (int)107, (int)104)).build();
            case EntityType.SALMON -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)150, (int)14, (int)15)).build();
            case EntityType.SHULKER -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)137, (int)95, (int)137)).build();
            case EntityType.SILVERFISH -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)102, (int)102, (int)102)).build();
            case EntityType.SKELETON -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)181, (int)181, (int)181)).build();
            case EntityType.SKELETON_HORSE -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)97, (int)97, (int)74)).build();
            case EntityType.SLIME -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)76, (int)150, (int)58)).build();
            case EntityType.SPIDER -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)49, (int)42, (int)37)).build();
            case EntityType.SQUID -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)32, (int)55, (int)72)).build();
            case EntityType.STRAY -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)91, (int)111, (int)112)).build();
            case EntityType.STRIDER -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)146, (int)49, (int)51)).build();
            case EntityType.TADPOLE -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)102, (int)78, (int)57)).build();
            case EntityType.TROPICAL_FISH -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)224, (int)98, (int)20)).build();
            case EntityType.VEX -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)114, (int)135, (int)154)).build();
            case EntityType.VILLAGER -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)81, (int)56, (int)48)).build();
            case EntityType.VINDICATOR -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)140, (int)145, (int)145)).build();
            case EntityType.WANDERING_TRADER -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)65, (int)92, (int)141)).build();
            case EntityType.WARDEN -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)14, (int)66, (int)68)).build();
            case EntityType.WITCH -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)49, (int)0, (int)0)).build();
            case EntityType.WITHER_SKELETON, EntityType.WITHER -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)19, (int)19, (int)19)).build();
            case EntityType.WOLF -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)202, (int)198, (int)198)).build();
            case EntityType.ZOGLIN -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)186, (int)103, (int)80)).build();
            case EntityType.ZOMBIE -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)0, (int)164, (int)164)).build();
            case EntityType.ZOMBIE_HORSE -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)46, (int)77, (int)49)).build();
            case EntityType.ZOMBIE_VILLAGER -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)81, (int)56, (int)48)).build();
            case EntityType.ZOMBIFIED_PIGLIN -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)219, (int)138, (int)138)).build();
            default -> FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(Color.fromRGB((int)100, (int)100, (int)100)).build();
        };
    }

    @ParametersAreNonnullByDefault
    public static Map<String, Object> getTraitInfo(String traitId) {
        FileConfiguration traits = configManager.getTraits();
        ConfigurationSection trait = traits.getConfigurationSection(traitId);
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        if (trait == null) {
            return toReturn;
        }
        toReturn.put("id", traitId);
        toReturn.put("name", trait.getString("name"));
        toReturn.put("cooldown", trait.getInt("cooldown", 0));
        toReturn.put("type", trait.getString("type"));
        toReturn.put("lore", trait.getStringList("lore"));
        return toReturn;
    }

    @ParametersAreNonnullByDefault
    public static void spawnStateParticle(String state, Location location) {
        Particle.DustOptions dustOptions = switch (state) {
            case "Hostile" -> new Particle.DustOptions(Color.fromRGB((int)180, (int)0, (int)0), 1.0f);
            case "Aggressive" -> new Particle.DustOptions(Color.fromRGB((int)200, (int)20, (int)20), 1.0f);
            case "Gentle" -> new Particle.DustOptions(Color.fromRGB((int)20, (int)200, (int)20), 1.0f);
            case "Friendly" -> new Particle.DustOptions(Color.fromRGB((int)0, (int)180, (int)20), 1.0f);
            default -> new Particle.DustOptions(Color.fromRGB((int)80, (int)80, (int)80), 1.0f);
        };
        Collection<Player> collection = SpiritUtils.getNearImbued(location);
        for (Player player : collection) {
            player.spawnParticle(Particle.REDSTONE, location.clone().add(0.0, 0.5, 0.0), 1, 0.0, 0.0, 0.0, (Object)dustOptions);
        }
    }

    public static boolean isSpiritItem(ItemStack itemStack) {
        if (itemStack != null && itemStack.getType() == Material.FIREWORK_STAR && itemStack.getItemMeta() != null) {
            return PersistentDataAPI.hasString((PersistentDataHolder)itemStack.getItemMeta(), (NamespacedKey)Keys.spiritItemKey);
        }
        return false;
    }

    public static Set<ItemStack> getSpiritItems(Player player, EntityType type) {
        return RelationsAndStateRunnable.getSpiritCache().containsKey(player.getUniqueId()) && RelationsAndStateRunnable.getSpiritCache().get(player.getUniqueId()).containsKey(type) ? RelationsAndStateRunnable.getSpiritCache().get(player.getUniqueId()).get(type) : new HashSet<ItemStack>();
    }

    public static SpiritDefinition getSpiritDefinition(ItemStack item) {
        return spiritMap.get(EntityType.valueOf((String)PersistentDataAPI.getString((PersistentDataHolder)item.getItemMeta(), (NamespacedKey)Keys.spiritItemKey)));
    }

    public static double getTraitUsage(String trait) {
        return switch (trait) {
            case "Multishoot", "Hunger_Hit", "Slow_Shot" -> 2.0;
            case "Iron_Defense" -> 3.0;
            case "Clear_Effects", "Pig_Rancher", "Aquatic_Creature", "Ink_Spray", "Hops", "Group_Protection", "Infest", "High_Jump", "Morning_Gift", "Spitter", "Natural_Fisher", "Goats_Instrument", "Strange_Secrets", "Mini_Teleport", "Heavy_Hit" -> 5.0;
            case "Speedy_Escape", "Bee_Buddy", "Strong_Bones", "Stew_Maker", "Villager_Friend", "Glow_Up", "Undead_Protection", "Light_It_Up", "Poison_Spray", "Sleep_No_More" -> 10.0;
            case "Better_Brewer", "Targeted_Teleport", "Skull_Fire", "Dragons_Breath", "Dark_Aura" -> 15.0;
            case "Eggpult", "Webber", "Explode", "Lava_Walker", "Play_Dead", "Crit_hit", "Magma_Trap", "Tank", "Bullet_Swarm" -> 25.0;
            case "Another_Chance" -> 200.0;
            default -> 1.0;
        };
    }

    public static boolean useSpiritItem(Player player, EntityType type, ItemStack override) {
        SpiritDefinition definition = spiritMap.get(type);
        if (player == null) {
            return false;
        }
        if (override != null) {
            return SpiritUtils.tryUseSpirit(player, override, definition, true);
        }
        for (ItemStack spiritItem : SpiritUtils.getSpiritItems(player, type)) {
            boolean result = SpiritUtils.tryUseSpirit(player, spiritItem, definition, false);
            if (!result) continue;
            return true;
        }
        return false;
    }

    private static boolean tryUseSpirit(Player player, ItemStack spiritItem, SpiritDefinition definition, boolean notif) {
        double usage;
        String name = ChatColors.color((String)(SpiritUtils.tierColor(definition.getTier()) + ChatUtils.humanize((String)definition.getType().name())));
        ItemMeta meta = spiritItem.getItemMeta();
        String state = PersistentDataAPI.getString((PersistentDataHolder)meta, (NamespacedKey)Keys.spiritStateKey);
        Map<String, Object> traitInfo = SpiritUtils.getTraitInfo(definition.getTrait());
        if (SpiritUtils.getStates().indexOf(state) <= 2 && notif) {
            player.sendMessage(ChatMessageType.ACTION_BAR, new BaseComponent[]{new net.md_5.bungee.api.chat.TextComponent(SpiritUtils.getTranslation("messages.traits.incorrect_state").replace("{tier_color_and_mob_type}", name))});
            return false;
        }
        double singleProgress = PersistentDataAPI.getDouble((PersistentDataHolder)meta, (NamespacedKey)Keys.spiritProgressKey);
        double progress = state.equals("Gentle") ? singleProgress : 100.0 + singleProgress;
        if (progress >= (usage = SpiritUtils.getTraitUsage(definition.getTrait()))) {
            SpiritUtils.updateSpiritItemProgress(spiritItem, -SpiritUtils.getTraitUsage(definition.getTrait()));
            if (traitInfo.get("type").equals("Passive")) {
                player.sendMessage(ChatMessageType.ACTION_BAR, new BaseComponent[]{new net.md_5.bungee.api.chat.TextComponent(SpiritUtils.getTranslation("messages.traits.used_passive").replace("{tier_color_and_mob_type}", name))});
            }
            return true;
        }
        if (notif) {
            player.sendMessage(ChatMessageType.ACTION_BAR, new BaseComponent[]{new net.md_5.bungee.api.chat.TextComponent(SpiritUtils.getTranslation("messages.traits.not_enough_progress").replace("{tier_color_and_mob_type}", name).replace("{progress}", String.valueOf(progress)).replace("{required_progress}", String.valueOf(usage)))});
        }
        return false;
    }

    public static void updateSpiritItemProgress(ItemStack item, double updateWith) {
        ItemMeta meta = item.getItemMeta();
        List lore = meta.lore();
        int passOn = PersistentDataAPI.getInt((PersistentDataHolder)meta, (NamespacedKey)Keys.spiritPassOnKey);
        int toPass = SpiritUtils.getSpiritDefinition(item).getGoal().getAmount();
        String state = PersistentDataAPI.getString((PersistentDataHolder)meta, (NamespacedKey)Keys.spiritStateKey);
        double progress = PersistentDataAPI.getDouble((PersistentDataHolder)meta, (NamespacedKey)Keys.spiritProgressKey) + updateWith;
        if (progress >= 100.0) {
            int index = SpiritUtils.getStates().indexOf(state);
            boolean canIncrease = !SpiritUtils.getStates().get(SpiritUtils.getStates().size() - 1).equals(state);
            state = canIncrease ? SpiritUtils.getStates().get(index + 1) : state;
            progress = canIncrease ? progress - 100.0 : 100.0;
        } else if (progress <= 0.0) {
            int index = SpiritUtils.getStates().indexOf(state);
            boolean canDecrease = index != 0;
            state = canDecrease ? SpiritUtils.getStates().get(index - 1) : state;
            progress = canDecrease ? progress + 100.0 : 0.0;
        }
        progress = BigDecimal.valueOf(progress).setScale(2, RoundingMode.HALF_UP).doubleValue();
        PersistentDataAPI.setDouble((PersistentDataHolder)meta, (NamespacedKey)Keys.spiritProgressKey, (double)progress);
        PersistentDataAPI.setString((PersistentDataHolder)meta, (NamespacedKey)Keys.spiritStateKey, (String)state);
        lore.set(2, Component.text((String)SpiritUtils.getTranslation("names.items.spirit_item.current_state_lore").replace("{state_color}", SpiritUtils.stateColor(state).toString()).replace("{state}", state)));
        lore.set(5, Component.text((String)SpiritUtils.getTranslation("names.items.spirit_item.progress_lore").replace("{progress_bar}", SpiritUtils.getProgress(progress))));
        lore.set(6, Component.text((String)SpiritUtils.getTranslation("names.items.spirit_item.pass_on_lore").replace("{pass_on_progress}", String.valueOf(passOn)).replace("{pass_on_requirement}", String.valueOf(toPass)).replace("{locked}", PersistentDataAPI.hasBoolean((PersistentDataHolder)meta, (NamespacedKey)Keys.spiritLocked) && PersistentDataAPI.getBoolean((PersistentDataHolder)meta, (NamespacedKey)Keys.spiritLocked) ? SpiritUtils.getTranslation("names.items.spirit_item.is_locked") : "")));
        meta.lore(lore);
        item.setItemMeta(meta);
    }

    @ParametersAreNonnullByDefault
    public static Collection<Entity> getNearbySpirits(Location location) {
        ArrayList<Entity> returnList = new ArrayList<Entity>();
        for (LivingEntity entity : SpiritUtils.spiritEntityManager.entityCollection) {
            if (!entity.getLocation().isWorldLoaded() || !location.isWorldLoaded() || entity.getLocation().getWorld() != location.getWorld() || !(location.distance(entity.getLocation()) <= 48.0)) continue;
            returnList.add((Entity)entity);
        }
        return returnList;
    }

    @Nullable
    public static String getSpawnMob(Location location) {
        List<List<EntityType>> tierMap = spiritsManager.getTierMaps();
        World world = location.getWorld();
        Biome biome = location.getBlock().getBiome();
        World.Environment dimension = world.getEnvironment();
        boolean isDay = world.isDayTime();
        int chance = ThreadLocalRandom.current().nextInt(1, 101);
        String spirit = null;
        int tier = chance == 100 ? 4 : (chance >= 90 ? 3 : (chance >= 70 ? 2 : 1));
        List<EntityType> getFrom = tierMap.get(tier - 1);
        Collections.shuffle(getFrom);
        for (EntityType entityType : getFrom) {
            boolean timeRight;
            if (spirit != null) continue;
            SpiritDefinition definition = spiritMap.get(entityType);
            List<String> times = definition.getTimes();
            if (dimension != World.Environment.valueOf((String)definition.getDimension()) || !definition.getTimes().isEmpty() && !(timeRight = times.contains("Day") && isDay || times.contains("Night") && !isDay)) continue;
            if (!definition.getBiomeGroup().isEmpty()) {
                boolean inBiome = biome.equals((Object)Biome.CUSTOM);
                if (!inBiome) {
                    for (String biomeId : definition.getBiomeGroup()) {
                        inBiome = inBiome || configManager.getBiomeMap().get(biomeId).contains(biome.name().toLowerCase());
                    }
                }
                if (!inBiome) continue;
            }
            spirit = entityType.name();
        }
        return spirit;
    }

    public static boolean canSpawn() {
        return spiritIdMap.size() < config.getInt("options.max-spirits", 40);
    }

    public static boolean imbuedCheck(ItemStack helmetItem) {
        return SlimefunItem.getByItem((ItemStack)helmetItem) != null && SlimefunItem.getByItem((ItemStack)helmetItem).getId().equals(ItemStacks.SU_SPIRIT_LENSES.getItemId()) || PersistentDataAPI.hasByte((PersistentDataHolder)helmetItem.getItemMeta(), (NamespacedKey)Keys.imbuedKey) && PersistentDataAPI.getByte((PersistentDataHolder)helmetItem.getItemMeta(), (NamespacedKey)Keys.imbuedKey) == 2;
    }

    public static boolean isLocked(ItemStack itemStack) {
        return PersistentDataAPI.hasBoolean((PersistentDataHolder)itemStack.getItemMeta(), (NamespacedKey)Keys.spiritLocked) && PersistentDataAPI.getBoolean((PersistentDataHolder)itemStack.getItemMeta(), (NamespacedKey)Keys.spiritLocked);
    }

    public static Collection<Player> getNearImbued(Location location) {
        Collection collection = location.getWorld().getNearbyEntities(location, 48.0, 48.0, 48.0);
        ArrayList<Player> toReturn = new ArrayList<Player>();
        for (Entity entity : collection) {
            Player player;
            ItemStack helmetItem;
            if (!(entity instanceof Player) || (helmetItem = (player = (Player)entity).getInventory().getHelmet()) == null || !SpiritUtils.imbuedCheck(helmetItem)) continue;
            toReturn.add(player);
        }
        return toReturn;
    }

    public static int getPlayerCap() {
        return config.getInt("options.player-spirit-cap", 4);
    }

    public static ItemStack spiritItem(String state, SpiritDefinition definition) {
        ItemStack itemStack = new ItemStack(Material.FIREWORK_STAR);
        ItemMeta itemMeta = itemStack.getItemMeta();
        ArrayList<TextComponent> itemLore = new ArrayList<TextComponent>();
        ChatColor tierColor = SpiritUtils.tierColor(definition.getTier());
        ChatColor stateColor = SpiritUtils.stateColor(state);
        String spiritType = ChatUtils.humanize((String)definition.getType().name());
        Map<String, Object> traitInfo = SpiritUtils.getTraitInfo(definition.getTrait());
        ((FireworkEffectMeta)itemMeta).setEffect(SpiritUtils.effectColor(definition.getType()));
        PersistentDataAPI.setBoolean((PersistentDataHolder)itemMeta, (NamespacedKey)Keys.spiritLocked, (boolean)false);
        PersistentDataAPI.setString((PersistentDataHolder)itemMeta, (NamespacedKey)Keys.spiritUniqueKey, (String)String.valueOf(System.currentTimeMillis()));
        PersistentDataAPI.setString((PersistentDataHolder)itemMeta, (NamespacedKey)Keys.spiritItemKey, (String)definition.getType().toString());
        PersistentDataAPI.setString((PersistentDataHolder)itemMeta, (NamespacedKey)Keys.spiritStateKey, (String)state);
        PersistentDataAPI.setDouble((PersistentDataHolder)itemMeta, (NamespacedKey)Keys.spiritProgressKey, (double)0.0);
        PersistentDataAPI.setInt((PersistentDataHolder)itemMeta, (NamespacedKey)Keys.spiritPassOnKey, (int)0);
        itemMeta.displayName((Component)Component.text((String)SpiritUtils.getTranslation("names.items.spirit_item.name").replace("{tier_color}", tierColor.toString()).replace("{mob_type}", spiritType)));
        itemLore.add(Component.text((String)""));
        itemLore.add(Component.text((String)SpiritUtils.getTranslation("names.items.spirit_item.tier_lore").replace("{tier_color}", tierColor.toString()).replace("{tier}", String.valueOf(definition.getTier()))));
        itemLore.add(Component.text((String)SpiritUtils.getTranslation("names.items.spirit_item.current_state_lore").replace("{state_color}", stateColor.toString()).replace("{state}", state)));
        itemLore.add(Component.text((String)ChatColors.color((String)SpiritUtils.getTranslation("names.items.spirit_item.trait_lore").replace("{trait_name}", (String)traitInfo.get("name")).replace("{trait_type}", (String)traitInfo.get("type")))));
        itemLore.add(Component.text((String)""));
        itemLore.add(Component.text((String)SpiritUtils.getTranslation("names.items.spirit_item.progress_lore").replace("{progress_bar}", SpiritUtils.getProgress(0.0))));
        itemLore.add(Component.text((String)SpiritUtils.getTranslation("names.items.spirit_item.pass_on_lore").replace("{pass_on_progress}", "0").replace("{pass_on_requirement}", String.valueOf(definition.getGoal().getAmount())).replace("{locked}", "")));
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        itemMeta.lore(itemLore);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static String getProgress(double progress) {
        String base = "\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6";
        int divideAt = (int)(progress / 5.0);
        return progress + "% " + ChatColors.color((String)(ChatColor.GREEN + "\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6".substring(0, divideAt) + ChatColor.GRAY + "\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6".substring(divideAt)));
    }

    public static int getTierChance(int tier) {
        return switch (tier) {
            case 2, 3 -> 50;
            case 4 -> 25;
            default -> 75;
        };
    }

    public static Block getSpawnBlock(Location location) {
        World world = location.getWorld();
        int x = new Random().nextInt(17) * (new Random().nextBoolean() ? 1 : -1) + location.getBlockX();
        int z = new Random().nextInt(17) * (new Random().nextBoolean() ? 1 : -1) + location.getBlockZ();
        int y = location.getBlockY();
        if (world.getBlockAt(x, y, z).getType() != Material.AIR) {
            boolean foundAir = false;
            while (!foundAir) {
                if (world.getBlockAt(x, ++y, z).getType() != Material.AIR) continue;
                foundAir = true;
            }
        }
        return world.getBlockAt(x, y, z);
    }

    public static List<Entity> getLookingList(Player player) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Entity e : player.getNearbyEntities(10.0, 10.0, 10.0)) {
            if (!(e instanceof Allay) || !SpiritUtils.getLookingAt(player, (LivingEntity)e)) continue;
            entities.add(e);
        }
        return entities;
    }

    public static boolean getLookingAt(Player player, LivingEntity livingEntity) {
        Location eye = player.getEyeLocation();
        Vector toEntity = livingEntity.getLocation().toVector().subtract(eye.toVector());
        double dot = toEntity.normalize().dot(eye.getDirection());
        return dot > 0.99;
    }

    public static Entity spawnProjectile(Player player, Class<? extends Entity> entity, String reason) {
        Location location = player.getLocation();
        float yaw = location.getYaw();
        double D = 1.0;
        double x = -1.0 * Math.sin((double)yaw * Math.PI / 180.0);
        double z = 1.0 * Math.cos((double)yaw * Math.PI / 180.0);
        Entity projectile = player.getWorld().spawn(location.add(x, 1.162, z), entity);
        projectile.setVelocity(location.getDirection().multiply(2));
        PersistentDataAPI.setString((PersistentDataHolder)projectile, (NamespacedKey)Keys.entityKey, (String)reason);
        PersistentDataAPI.setString((PersistentDataHolder)projectile, (NamespacedKey)Keys.ownerKey, (String)player.getUniqueId().toString());
        return projectile;
    }

    public static List<Block> getNearbyBlocks(Block block, int radius) {
        ArrayList<Block> toReturn = new ArrayList<Block>();
        for (int x = -radius; x < radius + 1; ++x) {
            for (int y = -radius; y < radius + 1; ++y) {
                for (int z = -radius; z < radius + 1; ++z) {
                    Block relative = block.getRelative(x, y, z);
                    toReturn.add(relative);
                }
            }
        }
        return toReturn;
    }

    public static ItemStack getFilledBook(SpiritDefinition definition) {
        String type = definition.getType().name();
        ItemStack book = SpiritUtils.getFilledBook(type);
        BookMeta bookMeta = (BookMeta)book.getItemMeta();
        String name = ChatUtils.humanize((String)type) + " Spirit";
        bookMeta.setAuthor(name);
        bookMeta.setTitle(name);
        book.setItemMeta((ItemMeta)bookMeta);
        return book;
    }

    public static ItemStack getFilledBook(String bookId) {
        FileConfiguration books = configManager.getBooks();
        ConfigurationSection bookConfig = books.getConfigurationSection(bookId);
        ItemStack filledBook = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta bookMeta = (BookMeta)filledBook.getItemMeta();
        if (bookConfig == null || bookConfig.getConfigurationSection("pages") == null) {
            return filledBook;
        }
        ConfigurationSection pages = bookConfig.getConfigurationSection("pages");
        for (String pageNum : pages.getKeys(false)) {
            bookMeta.addPages(new Component[]{MiniMessage.miniMessage().deserialize((Object)StringUtils.join((Collection)pages.getStringList(pageNum), (String)"\n"))});
        }
        bookMeta.setAuthor(bookConfig.getString("author", "Spirit"));
        bookMeta.setTitle(bookConfig.getString("title", "Written Book"));
        filledBook.setItemMeta((ItemMeta)bookMeta);
        return filledBook;
    }

    public static void fillSlots(ChestMenu chestMenu, int[] slots, ItemStack itemStack) {
        for (int slot : slots) {
            chestMenu.addItem(slot, itemStack, ChestMenuUtils.getEmptyClickHandler());
        }
    }

    public static boolean chance(int chance) {
        return ThreadLocalRandom.current().nextInt(1, 101) <= chance;
    }
}

