/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.implementation.multiblocks;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class SpiritualAltarPiece
extends SlimefunItem {
    public SpiritualAltarPiece(ItemGroup category, @Nonnull SlimefunItemStack item, @Nonnull RecipeType recipeType, @Nonnull ItemStack[] recipe, int amount) {
        super(category, item, recipeType, recipe, (ItemStack)new SlimefunItemStack(item, amount));
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{this.onBlockBreak()});
    }

    private BlockBreakHandler onBlockBreak() {
        return new BlockBreakHandler(false, false){

            @ParametersAreNonnullByDefault
            public void onPlayerBreak(BlockBreakEvent e, ItemStack item, List<ItemStack> drops) {
                Block b = SpiritualAltarPiece.this.findAltar(e.getBlock());
                if (b != null && BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"complete") != null && BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"complete").equals("true")) {
                    BlockStorage.addBlockInfo((Block)b, (String)"complete", (String)"false");
                    e.getPlayer().sendMessage(SpiritUtils.getTranslation("messages.altar.broken"));
                }
                BlockStorage.clearBlockInfo((Block)e.getBlock());
            }
        };
    }

    @Nullable
    private Block findAltar(@Nonnull Block b) {
        for (int x = -2; x <= 2; ++x) {
            for (int y = -3; y <= 0; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    Block block;
                    if (x == 0 && y == 0 && z == 0 || (block = b.getRelative(x, y, z)).getType() != Material.CHISELED_QUARTZ_BLOCK || BlockStorage.getLocationInfo((Location)block.getLocation(), (String)"id") == null || !BlockStorage.getLocationInfo((Location)block.getLocation(), (String)"id").contains("SU_CHARGED_CORE")) continue;
                    return block;
                }
            }
        }
        return null;
    }
}

