/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.managers;

import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.justahuman.spiritsunchained.SpiritsUnchained;
import me.justahuman.spiritsunchained.utils.LogUtils;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final FileConfiguration spirits;
    private final FileConfiguration traits;
    private final FileConfiguration playerData;
    private final FileConfiguration biomeGroups;
    private final FileConfiguration rewards;
    private final FileConfiguration books;
    private final FileConfiguration language;
    private final Map<String, List<String>> biomeMap;

    public ConfigManager() {
        SpiritsUnchained instance = SpiritsUnchained.getInstance();
        YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(instance.getResource("config.yml")));
        for (Map.Entry entry : config.getValues(true).entrySet()) {
            instance.getConfig().addDefault((String)entry.getKey(), entry.getValue());
        }
        instance.getConfig().options().copyDefaults(true);
        instance.saveConfig();
        this.spirits = this.loadConfig("spirits.yml", true);
        this.traits = this.loadConfig("traits.yml", true);
        this.biomeGroups = this.loadConfig("biome-groups.yml", true);
        this.playerData = this.loadConfig("player-data.yml", false);
        this.rewards = this.loadConfig("rewards.yml", true);
        this.books = this.loadConfig("books.yml", true);
        this.language = this.loadConfig("language.yml", true);
        this.biomeMap = this.fillBiomeMap();
    }

    @Nonnull
    private FileConfiguration loadConfig(@Nonnull String name, boolean override) {
        SpiritsUnchained plugin = SpiritsUnchained.getInstance();
        File file = new File(plugin.getDataFolder(), name);
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        try {
            configuration = YamlConfiguration.loadConfiguration((Reader)new BufferedReader(new FileReader(file, StandardCharsets.UTF_8)));
            configuration.load(file);
            if (override) {
                this.overrideConfiguration((FileConfiguration)configuration, file, name);
            }
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        return configuration;
    }

    @ParametersAreNonnullByDefault
    private void overrideConfiguration(FileConfiguration config, File file, String fileName) throws IOException {
        InputStream inputStream = SpiritsUnchained.getInstance().getResource(fileName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        YamlConfiguration defaults = YamlConfiguration.loadConfiguration((Reader)reader);
        config.addDefaults((Configuration)defaults);
        config.options().copyDefaults(true);
        config.save(file);
    }

    public void save() {
        LogUtils.logInfo("Saving Player Data");
        File file = new File(SpiritsUnchained.getInstance().getDataFolder(), "player-data.yml");
        try {
            this.playerData.save(file);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private Map<String, List<String>> fillBiomeMap() {
        HashMap<String, List<String>> finalMap = new HashMap<String, List<String>>();
        for (String group : this.biomeGroups.getKeys(false)) {
            finalMap.put(group, this.biomeGroups.getStringList(group));
        }
        return finalMap;
    }

    public String getTranslation(String path) {
        return ChatColors.color((String)this.language.getString(path, "Invalid Path!"));
    }

    public List<String> getTranslationList(String path) {
        return ConfigManager.colorList(this.language.getStringList(path));
    }

    public static List<String> colorList(List<String> toColor) {
        ArrayList<String> toReturn = new ArrayList<String>();
        for (String line : toColor) {
            toReturn.add(ChatColors.color((String)line));
        }
        return toReturn;
    }

    public FileConfiguration getSpirits() {
        return this.spirits;
    }

    public FileConfiguration getTraits() {
        return this.traits;
    }

    public FileConfiguration getPlayerData() {
        return this.playerData;
    }

    public FileConfiguration getBiomeGroups() {
        return this.biomeGroups;
    }

    public FileConfiguration getRewards() {
        return this.rewards;
    }

    public FileConfiguration getBooks() {
        return this.books;
    }

    public FileConfiguration getLanguage() {
        return this.language;
    }

    public Map<String, List<String>> getBiomeMap() {
        return this.biomeMap;
    }
}

