/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.runnables;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import me.justahuman.spiritsunchained.utils.PlayerUtils;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class PassivesRunnable
extends BukkitRunnable {
    public void run() {
        for (World world : Bukkit.getWorlds()) {
            for (Player player : world.getPlayers()) {
                this.checkPassives(player);
            }
        }
    }

    private void checkPassives(Player player) {
        Block headBlock;
        if (SpiritUtils.useSpiritItem(player, EntityType.PARROT, null)) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, 1220, 0, true));
        }
        if (SpiritUtils.useSpiritItem(player, EntityType.IRON_GOLEM, null)) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 1220, 0, true));
        }
        if ((headBlock = player.getLocation().getBlock().getRelative(BlockFace.UP)).isLiquid() && player.isSwimming() && SpiritUtils.useSpiritItem(player, EntityType.DOLPHIN, null)) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.DOLPHINS_GRACE, 1220, 2, true));
        }
        if (headBlock.isLiquid() && player.isSwimming() && SpiritUtils.useSpiritItem(player, EntityType.POLAR_BEAR, null)) {
            PlayerUtils.addOrDropItem(player, new ItemStack(Material.COD));
        }
        if (player.getInventory().contains(Material.GOLD_INGOT) && SpiritUtils.useSpiritItem(player, EntityType.PIGLIN, null)) {
            PlayerInventory inventory = player.getInventory();
            for (ItemStack item : inventory.getContents()) {
                if (item == null || item.getType() != Material.GOLD_INGOT) continue;
                item.subtract();
                PlayerUtils.addOrDropItem(player, SlimefunItem.getById((String)"STRANGE_NETHER_GOO").getItem().clone());
            }
        }
    }
}

