/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.runnables;

import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import me.justahuman.spiritsunchained.SpiritsUnchained;
import me.justahuman.spiritsunchained.spirits.SpiritDefinition;
import me.justahuman.spiritsunchained.utils.Keys;
import me.justahuman.spiritsunchained.utils.ParticleUtils;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.scheduler.BukkitRunnable;

public class RelationsAndStateRunnable
extends BukkitRunnable {
    static final HashMap<UUID, EnumMap<EntityType, Set<ItemStack>>> spiritCache = new HashMap();

    public void run() {
        Map<EntityType, SpiritDefinition> spiritMap = SpiritsUnchained.getSpiritsManager().getSpiritMap();
        for (World world : Bukkit.getWorlds()) {
            for (Player player : world.getPlayers()) {
                this.checkSpirits(player, spiritMap);
            }
        }
    }

    private void checkSpirits(Player player, Map<EntityType, SpiritDefinition> spiritMap) {
        ItemStack[] contents;
        EnumMap cacheEntry = new EnumMap(EntityType.class);
        PlayerInventory inventory = player.getInventory();
        for (ItemStack item : contents = inventory.getContents()) {
            if (item == null || item.getType() != Material.FIREWORK_STAR || !SpiritUtils.isSpiritItem(item)) continue;
            Location location = player.getLocation();
            World world = player.getWorld();
            ItemMeta meta = item.getItemMeta();
            String state = PersistentDataAPI.getString((PersistentDataHolder)meta, (NamespacedKey)Keys.spiritStateKey);
            EntityType type = EntityType.valueOf((String)PersistentDataAPI.getString((PersistentDataHolder)meta, (NamespacedKey)Keys.spiritItemKey));
            SpiritDefinition definition = spiritMap.get(type);
            Map<String, List<EntityType>> relations = definition.getRelations();
            Set<ItemStack> spirits = cacheEntry.containsKey(type) ? (Set)cacheEntry.get(type) : new HashSet();
            spirits.add(item);
            cacheEntry.put(type, spirits);
            for (EntityType scareType : relations.get("Scare")) {
                Set scared = cacheEntry.containsKey(scareType) ? (Set)cacheEntry.get(scareType) : new HashSet();
                for (ItemStack scare : scared) {
                    SpiritUtils.updateSpiritItemProgress(scare, 1.0 / (double)new Random().nextInt(1, 5));
                    world.dropItemNaturally(location, scare.clone());
                    inventory.remove(scare);
                    world.playSound(location, Sound.ENTITY_ITEM_PICKUP, 2.0f, 1.0f);
                    ParticleUtils.spawnParticleRadius(location, Particle.REDSTONE, 3.0, 30, "Colored", new Particle.DustOptions(Color.fromRGB((int)255, (int)0, (int)0), 1.0f));
                }
            }
            if (SpiritsUnchained.getInstance().getConfig().getBoolean("options.hostile-movement", true) && state.equals("Hostile")) {
                int index = new Random().nextInt(contents.length);
                ItemStack toMove = inventory.getItem(index) != null ? inventory.getItem(index).clone() : null;
                int moveTo = new Random().nextInt(contents.length);
                ItemStack toSwitch = inventory.getItem(moveTo) != null ? inventory.getItem(moveTo).clone() : null;
                inventory.setItem(index, toSwitch);
                inventory.setItem(moveTo, toMove);
            }
            if (!SpiritsUnchained.getInstance().getConfig().getBoolean("options.aggressive-damage", true) || !state.equals("Hostile") && !state.equals("Aggressive")) continue;
            player.damage((double)new Random().nextInt(2));
        }
        spiritCache.put(player.getUniqueId(), cacheEntry);
    }

    public static HashMap<UUID, EnumMap<EntityType, Set<ItemStack>>> getSpiritCache() {
        return spiritCache;
    }
}

