/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.implementation.multiblocks;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import me.justahuman.spiritsunchained.implementation.multiblocks.ChargedCore;
import me.justahuman.spiritsunchained.slimefun.Groups;
import me.justahuman.spiritsunchained.slimefun.ItemStacks;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class Tier3Altar
extends SlimefunItem {
    private static final Map<Vector, Material> blocks = new LinkedHashMap<Vector, Material>();
    private static final String complete = "complete";

    public Tier3Altar() {
        super((ItemGroup)Groups.SU_ALTAR_3, ItemStacks.SU_CHARGED_CORE_III, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{null, ItemStacks.SU_CHARGED_QUARTZ_III, null, ItemStacks.SU_CHARGED_QUARTZ_III, null, ItemStacks.SU_CHARGED_QUARTZ_III, null, ItemStacks.SU_CHARGED_QUARTZ_III, null});
        blocks.put(new Vector(2, 0, -2), Material.QUARTZ_PILLAR);
        blocks.put(new Vector(1, 0, -1), Material.QUARTZ_BLOCK);
        blocks.put(new Vector(1, 0, 0), Material.SMOOTH_QUARTZ);
        blocks.put(new Vector(1, 0, 1), Material.QUARTZ_BLOCK);
        blocks.put(new Vector(2, 0, 2), Material.QUARTZ_PILLAR);
        blocks.put(new Vector(0, 0, -1), Material.SMOOTH_QUARTZ);
        blocks.put(new Vector(0, 0, 0), Material.CHISELED_QUARTZ_BLOCK);
        blocks.put(new Vector(0, 0, 1), Material.SMOOTH_QUARTZ);
        blocks.put(new Vector(-2, 0, -2), Material.QUARTZ_PILLAR);
        blocks.put(new Vector(-1, 0, -1), Material.QUARTZ_BLOCK);
        blocks.put(new Vector(-1, 0, 0), Material.SMOOTH_QUARTZ);
        blocks.put(new Vector(-1, 0, 1), Material.QUARTZ_BLOCK);
        blocks.put(new Vector(-2, 0, 2), Material.QUARTZ_PILLAR);
        blocks.put(new Vector(2, 0, -1), Material.SMOOTH_QUARTZ_STAIRS);
        blocks.put(new Vector(2, 0, 0), Material.SMOOTH_QUARTZ_STAIRS);
        blocks.put(new Vector(2, 0, 1), Material.SMOOTH_QUARTZ_STAIRS);
        blocks.put(new Vector(-1, 0, 2), Material.SMOOTH_QUARTZ_STAIRS);
        blocks.put(new Vector(0, 0, 2), Material.SMOOTH_QUARTZ_STAIRS);
        blocks.put(new Vector(1, 0, 2), Material.SMOOTH_QUARTZ_STAIRS);
        blocks.put(new Vector(-2, 0, 1), Material.SMOOTH_QUARTZ_STAIRS);
        blocks.put(new Vector(-2, 0, 0), Material.SMOOTH_QUARTZ_STAIRS);
        blocks.put(new Vector(-2, 0, -1), Material.SMOOTH_QUARTZ_STAIRS);
        blocks.put(new Vector(1, 0, -2), Material.SMOOTH_QUARTZ_STAIRS);
        blocks.put(new Vector(0, 0, -2), Material.SMOOTH_QUARTZ_STAIRS);
        blocks.put(new Vector(-1, 0, -2), Material.SMOOTH_QUARTZ_STAIRS);
        blocks.put(new Vector(2, 1, -2), Material.QUARTZ_PILLAR);
        blocks.put(new Vector(2, 1, 2), Material.QUARTZ_PILLAR);
        blocks.put(new Vector(-2, 1, -2), Material.QUARTZ_PILLAR);
        blocks.put(new Vector(-2, 1, 2), Material.QUARTZ_PILLAR);
        blocks.put(new Vector(2, 2, -2), Material.QUARTZ_PILLAR);
        blocks.put(new Vector(2, 2, 2), Material.QUARTZ_PILLAR);
        blocks.put(new Vector(-2, 2, -2), Material.QUARTZ_PILLAR);
        blocks.put(new Vector(-2, 2, 2), Material.QUARTZ_PILLAR);
        blocks.put(new Vector(2, 3, -2), Material.SMOOTH_QUARTZ_STAIRS);
        blocks.put(new Vector(2, 3, 2), Material.SMOOTH_QUARTZ_STAIRS);
        blocks.put(new Vector(-2, 3, -2), Material.SMOOTH_QUARTZ_STAIRS);
        blocks.put(new Vector(-2, 3, 2), Material.SMOOTH_QUARTZ_STAIRS);
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public boolean isSynchronized() {
                return true;
            }

            public void tick(Block block, SlimefunItem slimefunItem, Config config) {
                ChargedCore.tick(block);
            }
        }});
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{this.onPlace(), this.onUse(), this.onBreak()});
    }

    private BlockPlaceHandler onPlace() {
        return new BlockPlaceHandler(false){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent e) {
                Block b = e.getBlockPlaced();
                BlockStorage.addBlockInfo((Block)b, (String)"particle", (String)"8");
                BlockStorage.addBlockInfo((Block)b, (String)"multiplier", (String)"4.0");
                if (Tier3Altar.this.isComplete(b)) {
                    BlockStorage.addBlockInfo((Block)b, (String)Tier3Altar.complete, (String)"true");
                    e.getPlayer().sendMessage(SpiritUtils.getTranslation("messages.altar.completed.3"));
                } else {
                    BlockStorage.addBlockInfo((Block)b, (String)Tier3Altar.complete, (String)"false");
                    e.getPlayer().sendMessage(SpiritUtils.getTranslation("messages.altar.complete_prompt"));
                }
            }
        };
    }

    private BlockUseHandler onUse() {
        return e -> {
            Block b = (Block)e.getClickedBlock().get();
            if (BlockStorage.getLocationInfo((Location)b.getLocation(), (String)complete).equals("false")) {
                if (this.isComplete(b)) {
                    BlockStorage.addBlockInfo((Block)b, (String)complete, (String)"true");
                    e.getPlayer().sendMessage(SpiritUtils.getTranslation("messages.altar.completed.3"));
                } else {
                    BlockStorage.addBlockInfo((Block)b, (String)complete, (String)"false");
                    e.getPlayer().sendMessage(SpiritUtils.getTranslation("messages.altar.not_completed"));
                }
            }
            e.cancel();
        };
    }

    private BlockBreakHandler onBreak() {
        return new BlockBreakHandler(false, false){

            public void onPlayerBreak(@Nonnull BlockBreakEvent e, @Nonnull ItemStack item, @Nonnull List<ItemStack> drops) {
                BlockStorage.addBlockInfo((Block)e.getBlock(), (String)Tier3Altar.complete, null);
                BlockStorage.clearBlockInfo((Block)e.getBlock());
                e.getPlayer().sendMessage(SpiritUtils.getTranslation("messages.altar.broken"));
            }
        };
    }

    private boolean isComplete(@Nonnull Block b) {
        for (Map.Entry<Vector, Material> entry : blocks.entrySet()) {
            Vector relative = entry.getKey();
            Material relativeMaterial = entry.getValue();
            Block relativeBlock = b.getRelative(relative.getBlockX(), relative.getBlockY(), relative.getBlockZ());
            if (relativeBlock.getType() == relativeMaterial && this.isAltarPiece(relativeBlock)) continue;
            return false;
        }
        return true;
    }

    private boolean isAltarPiece(@Nonnull Block b) {
        if (BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"id") == null) {
            return false;
        }
        return switch (BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"id")) {
            case "SU_CHARGED_QUARTZ_III", "SU_SMOOTH_CHARGED_QUARTZ_III", "SU_CHARGED_PILLAR_III", "SU_SMOOTH_CHARGED_STAIRS_III", "SU_CHARGED_CORE_III" -> true;
            default -> false;
        };
    }

    public static Map<Vector, Material> getBlocks() {
        return blocks;
    }
}

