/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.spirits;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.List;
import me.justahuman.spiritsunchained.SpiritsUnchained;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Goal {
    private final ItemStack displayStack;
    private final String goalType;
    private final String requiredType;
    private final ItemStack requiredStack;
    private final int amount;

    public Goal(String goalType, String requiredType, int amount) {
        this.goalType = goalType;
        this.requiredType = requiredType;
        this.amount = amount;
        this.requiredStack = this.createRequirementStack();
        this.displayStack = this.createDisplayStack();
    }

    private static String translate(String path) {
        return SpiritsUnchained.getConfigManager().getTranslation("names.spirit_group.goal." + path);
    }

    private ItemStack createDisplayStack() {
        String addition = this.amount > 1 ? "s" : "";
        String loreEnd = this.amount + " " + ChatUtils.humanize((String)this.requiredType);
        String name = Goal.translate("name");
        CustomItemStack kill = new CustomItemStack(Material.DIAMOND_SWORD, name, new String[]{"", Goal.translate("kill.label") + addition, Goal.translate("kill.value").replace("{amount_and_mob}", loreEnd)});
        CustomItemStack item = new CustomItemStack(Material.STICK, name, new String[]{"", Goal.translate("item.label") + addition, Goal.translate("item.value").replace("{amount_and_item}", loreEnd)});
        if (this.goalType.equals("Item")) {
            try {
                item.setType(Material.valueOf((String)this.requiredType));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        CustomItemStack slimefunItem = new CustomItemStack(Material.SLIME_BALL, name, new String[]{"", Goal.translate("slimefun_item.label") + addition, Goal.translate("slimefun_item.value").replace("{amount_and_item}", loreEnd)});
        if (this.goalType.equals("SlimefunItem")) {
            try {
                ItemStack properSlimefunItem = SpiritsUnchained.getSlimefunItem(this.requiredType).clone();
                List newLore = slimefunItem.lore();
                ItemMeta newMeta = properSlimefunItem.getItemMeta();
                newLore.set(2, Component.text((String)Goal.translate("slimefun_item.value").replace("{amount_and_item}", this.amount + " " + properSlimefunItem.getItemMeta().getDisplayName())));
                newMeta.displayName((Component)Component.text((String)name));
                properSlimefunItem.setItemMeta(newMeta);
                properSlimefunItem.lore(newLore);
                slimefunItem = properSlimefunItem;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        CustomItemStack breed = new CustomItemStack(Material.WHEAT, name, new String[]{"", Goal.translate("breed.label"), Goal.translate("breed.value").replace("{amount_and_mob}", loreEnd)});
        return switch (this.goalType) {
            case "Item" -> item;
            case "SlimefunItem" -> slimefunItem;
            case "Breed" -> breed;
            default -> kill;
        };
    }

    private ItemStack createRequirementStack() {
        ItemStack toReturn = new ItemStack(Material.AIR);
        if (this.goalType.equals("Item")) {
            toReturn = new ItemStack(Material.valueOf((String)this.requiredType));
        } else if (this.goalType.equals("SlimefunItem")) {
            toReturn = SlimefunItem.getById((String)this.requiredType).getItem().clone();
        }
        return toReturn;
    }

    public ItemStack getDisplayStack() {
        return this.displayStack;
    }

    public String getGoalType() {
        return this.goalType;
    }

    public String getRequiredType() {
        return this.requiredType;
    }

    public ItemStack getRequiredStack() {
        return this.requiredStack;
    }

    public int getAmount() {
        return this.amount;
    }
}

