/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.spiritsunchained.slimefun;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineTier;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineType;
import io.github.thebusybiscuit.slimefun4.utils.LoreBuilder;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ColoredFireworkStar;
import me.justahuman.spiritsunchained.utils.SpiritUtils;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ItemStacks {
    public static final SlimefunItemStack SU_INFUSED_MEMBRANE = new SlimefunItemStack("SU_INFUSED_MEMBRANE", ItemStacks.getEnchanted(new ItemStack(Material.PHANTOM_MEMBRANE)), ItemStacks.name("infused_membrane"), ItemStacks.lore("infused_membrane", new String[0]));
    public static final SlimefunItemStack SU_INFUSED_FEATHER = new SlimefunItemStack("SU_INFUSED_FEATHER", ItemStacks.getEnchanted(new ItemStack(Material.FEATHER)), ItemStacks.name("infused_feather"), ItemStacks.lore("infused_feather", new String[0]));
    public static final SlimefunItemStack SU_SOUL_STAINED_GLASS = new SlimefunItemStack("SU_SOUL_STAINED_GLASS", ItemStacks.getEnchanted(new ItemStack(Material.TINTED_GLASS)), ItemStacks.name("soul_stained_glass"), ItemStacks.lore("soul_stained_glass", new String[0]));
    public static final SlimefunItemStack SU_ECTOPLASM = new SlimefunItemStack("SU_ECTOPLASM", Material.SLIME_BALL, ItemStacks.name("ectoplasm"), ItemStacks.lore("ectoplasm", new String[0]));
    public static final SlimefunItemStack SU_UNIDENTIFIED_SPIRIT = new SlimefunItemStack("SU_UNIDENTIFIED_SPIRIT", (ItemStack)new ColoredFireworkStar(Color.fromRGB((int)100, (int)100, (int)100), ItemStacks.name("unidentified_spirit"), ItemStacks.lore("unidentified_spirit", new String[0])));
    public static final SlimefunItemStack SU_SPIRIT_BOTTLE = new SlimefunItemStack("SU_SPIRIT_BOTTLE", ItemStacks.addPotionEffect(PotionEffectType.LEVITATION, ItemStacks.getPotionColor(Material.SPLASH_POTION, 150, 150, 150), 5, 1), ItemStacks.name("spirit_bottle"), ItemStacks.lore("spirit_bottle", new String[0]));
    public static final SlimefunItemStack SU_SPIRIT_GUIDEBOOK = new SlimefunItemStack("SU_SPIRIT_GUIDEBOOK", Material.WRITTEN_BOOK, ItemStacks.name("spirit_guide_book"), ItemStacks.lore("spirit_guide_book", new String[0]));
    public static final SlimefunItemStack SU_IDENTIFYING_GLASS = new SlimefunItemStack("SU_IDENTIFYING_GLASS", Material.SPYGLASS, ItemStacks.name("identifying_glass"), ItemStacks.lore("identifying_glass", new String[0]));
    public static final SlimefunItemStack SU_SPIRIT_LENSES = new SlimefunItemStack("SU_SPIRIT_LENSES", Material.LEATHER_HELMET, ItemStacks.name("spirit_lenses"), ItemStacks.lore("spirit_lenses", new String[0]));
    public static final SlimefunItemStack SU_SPIRIT_NET = new SlimefunItemStack("SU_SPIRIT_NET", Material.COBWEB, ItemStacks.name("spirit_net"), ItemStacks.lore("spirit_net", new String[0]));
    public static final SlimefunItemStack SU_SPIRIT_BOOK = new SlimefunItemStack("SU_SPIRIT_BOOK", Material.BOOK, ItemStacks.name("spirit_book"), ItemStacks.lore("spirit_book", new String[0]));
    public static final SlimefunItemStack SU_SPIRIT_RUNE = new SlimefunItemStack("SU_SPIRIT_RUNE", (ItemStack)new ColoredFireworkStar(Color.fromRGB((int)154, (int)96, (int)255), ItemStacks.name("spirit_rune"), ItemStacks.lore("spirit_rune", new String[0])));
    public static final SlimefunItemStack SU_ELECTRIC_SPIRIT_CATCHER = new SlimefunItemStack("SU_ELECTRIC_SPIRIT_CATCHER", Material.SCULK_SHRIEKER, ItemStacks.name("electric_spirit_catcher"), ItemStacks.lore("electric_spirit_catcher", LoreBuilder.machine((MachineTier)MachineTier.ADVANCED, (MachineType)MachineType.MACHINE), LoreBuilder.speed((float)1.0f), LoreBuilder.powerBuffer((int)4000), LoreBuilder.powerPerSecond((int)250)));
    public static final SlimefunItemStack SU_ELECTRIC_SPIRIT_WRITER = new SlimefunItemStack("SU_ELECTRIC_SPIRIT_WRITER", Material.LECTERN, ItemStacks.name("electric_spirit_writer"), ItemStacks.lore("electric_spirit_writer", LoreBuilder.machine((MachineTier)MachineTier.ADVANCED, (MachineType)MachineType.MACHINE), LoreBuilder.speed((float)1.0f), LoreBuilder.powerBuffer((int)2000), LoreBuilder.powerPerSecond((int)125)));
    public static final String[] altarLore = ItemStacks.lore("altars", new String[0]);
    public static final SlimefunItemStack SU_CHARGED_QUARTZ_I = new SlimefunItemStack("SU_CHARGED_QUARTZ_I", Material.QUARTZ_BLOCK, ItemStacks.name("charged_quartz_1"), altarLore);
    public static final SlimefunItemStack SU_CHARGED_STAIRS_I = new SlimefunItemStack("SU_CHARGED_STAIRS_I", Material.QUARTZ_STAIRS, ItemStacks.name("charged_stairs_1"), altarLore);
    public static final SlimefunItemStack SU_CHARGED_CORE_I = new SlimefunItemStack("SU_CHARGED_CORE_I", Material.CHISELED_QUARTZ_BLOCK, ItemStacks.name("charged_core_1"), altarLore);
    public static final SlimefunItemStack SU_CHARGED_QUARTZ_II = new SlimefunItemStack("SU_CHARGED_QUARTZ_II", Material.QUARTZ_BLOCK, ItemStacks.name("charged_quartz_2"), altarLore);
    public static final SlimefunItemStack SU_CHARGED_PILLAR_II = new SlimefunItemStack("SU_CHARGED_PILLAR_II", Material.QUARTZ_PILLAR, ItemStacks.name("charged_pillar_2"), altarLore);
    public static final SlimefunItemStack SU_CHARGED_STAIRS_II = new SlimefunItemStack("SU_CHARGED_STAIRS_II", Material.QUARTZ_STAIRS, ItemStacks.name("charged_stairs_2"), altarLore);
    public static final SlimefunItemStack SU_CHARGED_CORE_II = new SlimefunItemStack("SU_CHARGED_CORE_II", Material.CHISELED_QUARTZ_BLOCK, ItemStacks.name("charged_core_2"), altarLore);
    public static final SlimefunItemStack SU_CHARGED_QUARTZ_III = new SlimefunItemStack("SU_CHARGED_QUARTZ_III", Material.QUARTZ_BLOCK, ItemStacks.name("charged_quartz_3"), altarLore);
    public static final SlimefunItemStack SU_CHARGED_PILLAR_III = new SlimefunItemStack("SU_CHARGED_PILLAR_III", Material.QUARTZ_PILLAR, ItemStacks.name("charged_pillar_3"), altarLore);
    public static final SlimefunItemStack SU_CHARGED_STAIRS_III = new SlimefunItemStack("SU_CHARGED_STAIRS_III", Material.QUARTZ_STAIRS, ItemStacks.name("charged_stairs_3"), altarLore);
    public static final SlimefunItemStack SU_CHARGED_CORE_III = new SlimefunItemStack("SU_CHARGED_CORE_III", Material.CHISELED_QUARTZ_BLOCK, ItemStacks.name("charged_core_3"), altarLore);
    public static final SlimefunItemStack SU_SMOOTH_CHARGED_QUARTZ_III = new SlimefunItemStack("SU_SMOOTH_CHARGED_QUARTZ_III", Material.SMOOTH_QUARTZ, ItemStacks.name("smooth_charged_quartz_3"), altarLore);
    public static final SlimefunItemStack SU_SMOOTH_CHARGED_STAIRS_III = new SlimefunItemStack("SU_SMOOTH_CHARGED_STAIRS_III", Material.SMOOTH_QUARTZ_STAIRS, ItemStacks.name("smooth_charged_stairs_3"), altarLore);

    private static ItemStack getEnchanted(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            itemMeta.addEnchant(Enchantment.ARROW_DAMAGE, 1, false);
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            itemStack.setItemMeta(itemMeta);
        }
        return itemStack;
    }

    private static ItemStack getPotionColor(Material material, int r, int g, int b) {
        ItemStack itemStack = new ItemStack(material);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
            PotionMeta potionMeta = (PotionMeta)itemMeta;
            potionMeta.setColor(Color.fromRGB((int)r, (int)g, (int)b));
            itemStack.setItemMeta((ItemMeta)potionMeta);
        }
        return itemStack;
    }

    private static String translate(String path) {
        return SpiritUtils.getTranslation("names.items." + path);
    }

    private static String name(String path) {
        return ItemStacks.translate(path + ".name");
    }

    private static String[] lore(String path, String ... addOn) {
        String line;
        int n;
        String[] originalLore = (String[])SpiritUtils.getTranslationList("names.items." + path + ".lore").toArray(String[]::new);
        String[] lore = new String[originalLore.length + addOn.length];
        int i = 0;
        String[] stringArray = originalLore;
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            lore[i] = line = stringArray[n];
            ++i;
        }
        stringArray = addOn;
        n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            lore[i] = line = stringArray[n];
            ++i;
        }
        return lore;
    }

    private static ItemStack addPotionEffect(PotionEffectType type, ItemStack itemStack, int duration, int amplifier) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        PotionMeta potionMeta = (PotionMeta)itemMeta;
        potionMeta.addCustomEffect(new PotionEffect(type, duration * 20, amplifier), true);
        itemStack.setItemMeta((ItemMeta)potionMeta);
        return itemStack;
    }
}

