/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.soundmuffler;

import dev.j3fftw.soundmuffler.SoundMuffler;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public class SoundMufflerMachine
extends SlimefunItem
implements EnergyNetComponent {
    private static final String ITEM_NAME = "&3Sound Muffler";
    private static final String ITEM_ID = "SOUND_MUFFLER";
    public static final int DISTANCE = 8;
    private static final int[] border = new int[]{1, 2, 3, 4, 5, 6, 7};

    public SoundMufflerMachine() {
        super(SoundMuffler.SOUND_MUFFLER, (ItemStack)new SlimefunItemStack(ITEM_ID, Material.WHITE_CONCRETE, ITEM_NAME, new String[]{"", "&7Muffles all sound in a", "&78 block radius", "", "&e\u26a1 Requires power to use"}), ITEM_ID, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{new ItemStack(Material.WHITE_WOOL), SlimefunItems.STEEL_PLATE, new ItemStack(Material.WHITE_WOOL), SlimefunItems.STEEL_PLATE, SlimefunItems.ELECTRIC_MOTOR, SlimefunItems.STEEL_PLATE, new ItemStack(Material.WHITE_WOOL), SlimefunItems.STEEL_PLATE, new ItemStack(Material.WHITE_WOOL)});
        this.addItemHandler(new ItemHandler[]{this.onPlace()});
        new BlockMenuPreset(ITEM_ID, ITEM_NAME){

            public void init() {
                SoundMufflerMachine.this.constructMenu(this);
            }

            public void newInstance(@Nonnull BlockMenu menu, @Nonnull Block b) {
                int volume = 10;
                boolean enabled = false;
                if (!BlockStorage.hasBlockInfo((Block)b) || BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"enabled") == null) {
                    BlockStorage.addBlockInfo((Block)b, (String)"volume", (String)String.valueOf(volume));
                    BlockStorage.addBlockInfo((Block)b, (String)"enabled", (String)String.valueOf(false));
                } else {
                    volume = Integer.parseInt(BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"volume"));
                    enabled = Boolean.parseBoolean(BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"enabled"));
                }
                menu.replaceExistingItem(8, (ItemStack)new CustomItemStack(enabled ? Material.REDSTONE : Material.GUNPOWDER, "&7Enabled: " + (enabled ? "&a\u2714" : "&4\u2718"), new String[]{"", "&e> Click to enable this Machine"}));
                menu.replaceExistingItem(0, (ItemStack)new CustomItemStack(Material.PAPER, "&eVolume: &b" + volume, new String[]{"&7Valid value range: 0-100", "&7L-click: -10", "&7R-click: +10", "&7With shift held: +/-1"}));
                int finalVolume = volume;
                menu.addMenuClickHandler(0, (p, arg1, arg2, arg3) -> {
                    int newVolume = arg3.isRightClicked() ? (arg3.isShiftClicked() ? Math.min(finalVolume + 1, 100) : Math.min(finalVolume + 10, 100)) : (arg3.isShiftClicked() ? Math.max(finalVolume - 1, 0) : Math.max(finalVolume - 10, 0));
                    BlockStorage.addBlockInfo((Block)b, (String)"volume", (String)String.valueOf(newVolume));
                    this.newInstance(menu, b);
                    return false;
                });
                menu.addMenuClickHandler(8, (p, arg1, arg2, arg3) -> {
                    String isEnabled = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"enabled");
                    if (isEnabled != null && isEnabled.equals("true")) {
                        BlockStorage.addBlockInfo((Block)b, (String)"enabled", (String)"false");
                    } else {
                        BlockStorage.addBlockInfo((Block)b, (String)"enabled", (String)"true");
                    }
                    this.newInstance(menu, b);
                    return false;
                });
            }

            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b, Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }
        };
    }

    protected void constructMenu(BlockMenuPreset preset) {
        for (int i : border) {
            preset.addItem(i, (ItemStack)new CustomItemStack(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]), (player, i1, itemStack, clickAction) -> false);
        }
    }

    private ItemHandler onPlace() {
        return new BlockPlaceHandler(false){

            public void onPlayerPlace(BlockPlaceEvent e) {
                BlockStorage.addBlockInfo((Block)e.getBlock(), (String)"enabled", (String)"false");
                BlockStorage.addBlockInfo((Block)e.getBlock(), (String)"volume", (String)"10");
            }
        };
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getEnergyConsumption() {
        return 8;
    }

    public int getCapacity() {
        return 352;
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                try {
                    SoundMufflerMachine.this.tick(b);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void uniqueTick() {
            }

            public boolean isSynchronized() {
                return true;
            }
        }});
    }

    private void tick(Block b) {
        if (BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"enabled").equals("true") && this.getCharge(b.getLocation()) > 8) {
            this.removeCharge(b.getLocation(), this.getEnergyConsumption());
        }
    }
}

