/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.soundmuffler;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class SoundMufflerListener
extends PacketAdapter
implements Listener,
EnergyNetComponent {
    public SoundMufflerListener(Plugin plugin) {
        super(plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.NAMED_SOUND_EFFECT, PacketType.Play.Server.ENTITY_SOUND});
    }

    public void onPacketSending(PacketEvent event) {
        if (event.getPacketType() == PacketType.Play.Server.NAMED_SOUND_EFFECT || event.getPacketType() == PacketType.Play.Server.ENTITY_SOUND) {
            Location loc;
            if (event.getPacketType() == PacketType.Play.Server.NAMED_SOUND_EFFECT) {
                int x = (Integer)event.getPacket().getIntegers().read(0) >> 3;
                int y = (Integer)event.getPacket().getIntegers().read(1) >> 3;
                int z = (Integer)event.getPacket().getIntegers().read(2) >> 3;
                loc = new Location(event.getPlayer().getWorld(), (double)x, (double)y, (double)z);
            } else if (event.getPacketType() == PacketType.Play.Server.ENTITY_SOUND) {
                loc = event.getPlayer().getWorld().getEntities().stream().filter(e -> e.getEntityId() == ((Integer)event.getPacket().getIntegers().read(1)).intValue()).map(Entity::getLocation).findAny().orElse(null);
            } else {
                return;
            }
            if (loc == null) {
                return;
            }
            Block soundMuff = this.findSoundMuffler(loc);
            if (soundMuff != null && BlockStorage.getLocationInfo((Location)soundMuff.getLocation(), (String)"enabled") != null && BlockStorage.getLocationInfo((Location)soundMuff.getLocation(), (String)"enabled").equals("true") && this.getCharge(soundMuff.getLocation()) > 8) {
                int volume = Integer.parseInt(BlockStorage.getLocationInfo((Location)soundMuff.getLocation(), (String)"volume"));
                if (volume == 0) {
                    event.setCancelled(true);
                } else {
                    event.getPacket().getFloat().write(0, (Object)Float.valueOf((float)volume / 100.0f));
                }
            }
        }
    }

    private Block findSoundMuffler(Location loc) {
        int dis = 8;
        for (int x = loc.getBlockX() - 8; x < loc.getBlockX() + 8; ++x) {
            for (int y = loc.getBlockY() - 8; y < loc.getBlockY() + 8; ++y) {
                for (int z = loc.getBlockZ() - 8; z < loc.getBlockZ() + 8; ++z) {
                    SlimefunItem item;
                    Block b;
                    if (!loc.getWorld().isChunkLoaded(x >> 4, z >> 4) || (b = loc.getWorld().getBlockAt(x, y, z)).getType() != Material.WHITE_CONCRETE || !BlockStorage.hasBlockInfo((Block)b) || !(item = BlockStorage.check((Block)b)).getId().equals("SOUND_MUFFLER")) continue;
                    return b;
                }
            }
        }
        return null;
    }

    public void start() {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this);
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return 352;
    }

    @Nonnull
    public String getId() {
        return "SOUND_MUFFLER";
    }
}

