/*
 * Decompiled with CFR 0.152.
 */
package me.ncbpfluffybear.slimyrepair;

import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.ncbpfluffybear.slimyrepair.SRItems;
import me.ncbpfluffybear.slimyrepair.SlimyRepair;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class SlimyAnvil
extends SlimefunItem
implements RecipeDisplayItem {
    public SlimyAnvil() {
        super(SRItems.slimy_repair, SRItems.SLIMY_ANVIL, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{new ItemStack(Material.SLIME_BLOCK), new ItemStack(Material.ANVIL), new ItemStack(Material.SLIME_BLOCK), new ItemStack(Material.ANVIL), new ItemStack(Material.IRON_BLOCK), new ItemStack(Material.ANVIL), new ItemStack(Material.SLIME_BLOCK), new ItemStack(Material.ANVIL), new ItemStack(Material.SLIME_BLOCK)});
        this.addItemHandler(new ItemHandler[]{this.onInteract()});
    }

    private ItemHandler onInteract() {
        return e -> {
            Optional opt = e.getClickedBlock();
            if (!opt.isPresent()) {
                return;
            }
            Player p = e.getPlayer();
            Block b = (Block)opt.get();
            SlimefunItem sfBlock = BlockStorage.check((Block)b);
            if (sfBlock != null && sfBlock == SRItems.SLIMY_ANVIL.getItem()) {
                ItemStack item = p.getInventory().getItemInMainHand();
                SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)item);
                ItemMeta meta = item.getItemMeta();
                if (meta instanceof Damageable) {
                    Damageable damageable = (Damageable)meta;
                    if (!SlimyRepair.repairMap.containsKey(sfItem)) {
                        this.send(p, "&cThis item can not be repaired!");
                        return;
                    }
                    if (!p.isSneaking()) {
                        ItemStack repairItem = (ItemStack)SlimyRepair.repairMap.get(sfItem).getFirstValue();
                        String itemName = repairItem instanceof SlimefunItemStack ? repairItem.getItemMeta().getDisplayName() : SlimyAnvil.toTitleCase(repairItem.getType().name().replace('_', ' '));
                        this.send(p, "&aThis item can be repaired!\n  &bRequires: &e" + itemName + "\n  &bRepairs: &e" + SlimyRepair.repairMap.get(sfItem).getSecondValue() + " Durability\n  &6Sneak and right click the Slimy Anvil to repair this item!!");
                        return;
                    }
                    if (!damageable.hasDamage()) {
                        this.send(p, "&cThis item is already repaired!");
                        return;
                    }
                    if (p.getInventory().containsAtLeast((ItemStack)SlimyRepair.repairMap.get(sfItem).getFirstValue(), 1)) {
                        int damage = damageable.getDamage();
                        p.getInventory().removeItem(new ItemStack[]{(ItemStack)SlimyRepair.repairMap.get(sfItem).getFirstValue()});
                        int newDamage = damage - (Integer)SlimyRepair.repairMap.get(sfItem).getSecondValue();
                        damageable.setDamage(Math.max(newDamage, 0));
                        item.setItemMeta(meta);
                        this.send(p, "&aYour item has been repaired!");
                    } else {
                        this.send(p, "&cYou do not have sufficient materials to repair this item!");
                    }
                }
            }
        };
    }

    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> displayRecipes = new ArrayList<ItemStack>();
        SlimyRepair.repairMap.forEach((key, mat) -> {
            ItemStack item = key.getItem().clone();
            ItemMeta meta = item.getItemMeta();
            ((Damageable)meta).setDamage(item.getType().getMaxDurability() - (Integer)mat.getSecondValue());
            item.setItemMeta(meta);
            displayRecipes.add(item);
            displayRecipes.add((ItemStack)mat.getFirstValue());
        });
        return displayRecipes;
    }

    private void send(Player p, String message) {
        p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7[&a&lSlimy&7&lRepair&8] " + message)));
    }

    public static String toTitleCase(String givenString) {
        String[] arr = givenString.toLowerCase().split(" ");
        StringBuilder sb = new StringBuilder();
        for (String s : arr) {
            sb.append(Character.toUpperCase(s.charAt(0))).append(s.substring(1)).append(" ");
        }
        return sb.toString().trim();
    }
}

