/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.items.guns;

import io.github.seggan.slimefunwarfare.SlimefunWarfare;
import io.github.seggan.slimefunwarfare.Util;
import io.github.seggan.slimefunwarfare.infinitylib.core.AbstractAddon;
import io.github.seggan.slimefunwarfare.items.Bullet;
import io.github.seggan.slimefunwarfare.lists.Categories;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.DamageableItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.backpacks.SlimefunBackpack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Gun
extends SlimefunItem
implements DamageableItem {
    public static final NamespacedKey LAST_USE = AbstractAddon.createKey("last_use");
    private final int range;
    private final int minRange;
    private final int damageDealt;
    private final int cooldown;

    public Gun(SlimefunItemStack item, ItemStack[] recipe, int range, int damage, double cooldown) {
        super(Categories.GUNS, item, RecipeType.ENHANCED_CRAFTING_TABLE, recipe);
        this.range = range;
        this.minRange = 0;
        this.damageDealt = damage;
        this.cooldown = (int)(cooldown * 1000.0);
        this.addItemHandler(new ItemHandler[]{this.getItemHandler()});
    }

    public Gun(SlimefunItemStack item, ItemStack[] recipe, int range, int minRange, int damage, double cooldown) {
        super(Categories.GUNS, item, RecipeType.ENHANCED_CRAFTING_TABLE, recipe);
        this.range = range;
        this.minRange = SlimefunWarfare.inst().getConfig().getBoolean("guns.min-range-on", true) ? minRange : 0;
        this.damageDealt = damage;
        this.cooldown = (int)(cooldown * 1000.0);
        this.addItemHandler(new ItemHandler[]{this.getItemHandler()});
    }

    public ItemUseHandler getItemHandler() {
        return e -> {
            e.cancel();
            Player p = e.getPlayer();
            ItemStack gun = p.getInventory().getItemInMainHand();
            if (!(SlimefunItem.getByItem((ItemStack)gun) instanceof Gun)) {
                return;
            }
            ItemMeta meta = gun.getItemMeta();
            PersistentDataContainer container = meta.getPersistentDataContainer();
            long lastUse = (Long)container.getOrDefault(LAST_USE, PersistentDataType.LONG, (Object)0L);
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastUse < (long)this.cooldown) {
                p.sendMessage(String.valueOf(ChatColor.RED) + "The gun is still reloading!");
                return;
            }
            container.set(LAST_USE, PersistentDataType.LONG, (Object)currentTime);
            gun.setItemMeta(meta);
            this.shoot(p, gun);
        };
    }

    public void shoot(@Nonnull Player p, @Nonnull ItemStack gun) {
        PlayerInventory inv = p.getInventory();
        Bullet bullet = Gun.checkAndConsume(inv.getItemInOffHand());
        if (bullet == null) {
            if (SlimefunWarfare.inst().getConfig().getBoolean("guns.use-bullets-from-inv", true)) {
                bullet = Gun.checkAndConsumeInv((Inventory)inv);
            }
            if (bullet == null) {
                p.sendMessage(String.valueOf(ChatColor.RED) + "You have run out of bullets!");
                return;
            }
        }
        Vector v = p.getEyeLocation().subtract(0.0, 1.0, 0.0).getDirection().multiply(20);
        LlamaSpit spit = (LlamaSpit)p.launchProjectile(LlamaSpit.class);
        spit.setMetadata("isGunBullet", (MetadataValue)new FixedMetadataValue((Plugin)SlimefunWarfare.inst(), (Object)true));
        spit.setMetadata("damage", (MetadataValue)new FixedMetadataValue((Plugin)SlimefunWarfare.inst(), (Object)((double)this.damageDealt * bullet.getMultiplier())));
        spit.setMetadata("isFire", (MetadataValue)new FixedMetadataValue((Plugin)SlimefunWarfare.inst(), (Object)bullet.isFire()));
        spit.setMetadata("locInfo", (MetadataValue)new FixedMetadataValue((Plugin)SlimefunWarfare.inst(), (Object)Util.serializeLocation(p.getEyeLocation())));
        spit.setMetadata("rangeInfo", (MetadataValue)new FixedMetadataValue((Plugin)SlimefunWarfare.inst(), (Object)(this.range + ":" + this.minRange)));
        spit.setVelocity(v);
    }

    public boolean isDamageable() {
        return true;
    }

    @Nullable
    protected static Bullet checkAndConsumeInv(@Nonnull Inventory inv) {
        ItemStack itemStack;
        Bullet bullet = null;
        ListIterator listIterator = inv.iterator();
        while (listIterator.hasNext() && (bullet = Gun.checkAndConsume(itemStack = (ItemStack)listIterator.next())) == null) {
        }
        return bullet;
    }

    @Nullable
    protected static Bullet checkAndConsume(@Nonnull ItemStack stack) {
        AtomicReference<Object> bullet = new AtomicReference<Object>(null);
        SlimefunItem item = SlimefunItem.getByItem((ItemStack)stack);
        if (item instanceof Bullet) {
            bullet.set(((Bullet)item));
            ItemUtils.consumeItem((ItemStack)stack, (boolean)true);
        } else if (item instanceof SlimefunBackpack) {
            PlayerProfile.getBackpack((ItemStack)stack, backpack -> bullet.set(Gun.checkAndConsumeInv(backpack.getInventory())));
        }
        return bullet.get();
    }

    public int getRange() {
        return this.range;
    }

    public int getMinRange() {
        return this.minRange;
    }

    public int getDamageDealt() {
        return this.damageDealt;
    }

    public int getCooldown() {
        return this.cooldown;
    }
}

