/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare;

import com.google.common.collect.Sets;
import io.github.seggan.slimefunwarfare.Setup;
import io.github.seggan.slimefunwarfare.Util;
import io.github.seggan.slimefunwarfare.infinitylib.common.Events;
import io.github.seggan.slimefunwarfare.infinitylib.common.Scheduler;
import io.github.seggan.slimefunwarfare.infinitylib.core.AbstractAddon;
import io.github.seggan.slimefunwarfare.infinitylib.metrics.bukkit.Metrics;
import io.github.seggan.slimefunwarfare.items.guns.Gun;
import io.github.seggan.slimefunwarfare.items.powersuits.ArmorPiece;
import io.github.seggan.slimefunwarfare.items.powersuits.Module;
import io.github.seggan.slimefunwarfare.items.powersuits.PowerSuit;
import io.github.seggan.slimefunwarfare.listeners.BreakListener;
import io.github.seggan.slimefunwarfare.listeners.BulletListener;
import io.github.seggan.slimefunwarfare.listeners.ChatListener;
import io.github.seggan.slimefunwarfare.listeners.ConcreteListener;
import io.github.seggan.slimefunwarfare.listeners.GrenadeListener;
import io.github.seggan.slimefunwarfare.listeners.HitListener;
import io.github.seggan.slimefunwarfare.listeners.ModuleListener;
import io.github.seggan.slimefunwarfare.listeners.NukeListener;
import io.github.seggan.slimefunwarfare.listeners.PyroListener;
import io.github.seggan.slimefunwarfare.lists.Categories;
import io.github.seggan.slimefunwarfare.lists.Items;
import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;

public class SlimefunWarfare
extends AbstractAddon
implements Listener {
    private static SlimefunWarfare instance = null;
    private static final Set<UUID> flying = new HashSet<UUID>();

    public SlimefunWarfare() {
        super("Seggan", "SlimefunWarfare", "master", "auto-update");
    }

    @Override
    public void enable() {
        instance = this;
        new Metrics(this, 9227);
        Events.registerListener(new BulletListener());
        Events.registerListener(new PyroListener());
        Events.registerListener(new GrenadeListener());
        Events.registerListener(new ConcreteListener());
        Events.registerListener(new NukeListener());
        Events.registerListener(new HitListener());
        Events.registerListener(new ModuleListener());
        Events.registerListener(new BreakListener());
        Events.registerListener(new ChatListener());
        Categories.setup(this);
        Setup.setupItems(this);
        Setup.setupMelee(this);
        Setup.setupBullets(this);
        Setup.setupGuns(this);
        Setup.setupExplosives(this);
        Setup.setupSpace(this);
        Setup.setupSuits(this);
        Setup.setupResearches();
        Module.setup(this);
        if (SlimefunWarfare.getJavaVersion() < 16) {
            SlimefunWarfare.log(Level.WARNING, "You are using a Java version that is less that 16! Please use Java 16 or above");
        }
        if (this.getConfig().getBoolean("guns.autoshoot", true)) {
            Scheduler.repeat(1, () -> {
                for (Player p : this.getServer().getOnlinePlayers()) {
                    ItemStack stack;
                    SlimefunItem item;
                    if (!p.isSneaking() || p.isFlying() || !((item = SlimefunItem.getByItem((ItemStack)(stack = p.getInventory().getItemInMainHand()))) instanceof Gun)) continue;
                    Gun gun = (Gun)item;
                    ItemMeta meta = stack.getItemMeta();
                    PersistentDataContainer container = meta.getPersistentDataContainer();
                    long lastUse = (Long)container.getOrDefault(Gun.LAST_USE, PersistentDataType.LONG, (Object)0L);
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - lastUse < (long)gun.getCooldown()) continue;
                    container.set(Gun.LAST_USE, PersistentDataType.LONG, (Object)currentTime);
                    stack.setItemMeta(meta);
                    gun.shoot(p, stack);
                }
            });
        }
        Scheduler.repeat(20, () -> {
            for (Player p : this.getServer().getOnlinePlayers()) {
                PlayerInventory inv = p.getInventory();
                ItemStack head = inv.getHelmet();
                Util.ifPowerSuit(head, suit -> SlimefunWarfare.process(head, PowerSuit.getModules(head), suit, p));
                ItemStack chest = inv.getChestplate();
                Util.ifPowerSuit(chest, suit -> SlimefunWarfare.process(chest, PowerSuit.getModules(chest), suit, p));
                ItemStack legs = inv.getLeggings();
                Util.ifPowerSuit(legs, suit -> SlimefunWarfare.process(legs, PowerSuit.getModules(legs), suit, p));
                ItemStack boots = inv.getBoots();
                Util.ifPowerSuit(boots, suit -> SlimefunWarfare.process(boots, PowerSuit.getModules(boots), suit, p), () -> {
                    UUID uuid = p.getUniqueId();
                    if (flying.contains(uuid)) {
                        flying.remove(uuid);
                        p.setAllowFlight(false);
                    }
                });
            }
        });
        if (this.getConfig().getBoolean("suits.flight-particles", true)) {
            Scheduler.repeat(4, () -> {
                for (UUID uuid : flying) {
                    Player p = this.getServer().getPlayer(uuid);
                    if (p == null) {
                        flying.remove(uuid);
                        return;
                    }
                    if (!p.isFlying()) continue;
                    p.getWorld().spawnParticle(Particle.SOUL_FIRE_FLAME, p.getLocation().subtract(0.0, 1.0, 0.0), 20, 0.5, 0.5, 0.5);
                }
            });
        }
        if (Slimefun.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_17)) {
            try {
                Class<?> orechid = Class.forName("me.profelements.dynatech.items.tools.Orechid");
                Method method = orechid.getDeclaredMethod("registerOre", Material.class, SlimefunItemStack.class, Float.TYPE);
                method.setAccessible(true);
                method.invoke(null, Material.WAXED_WEATHERED_CUT_COPPER_STAIRS, Items.OSMIUM_METEOR, 100 - this.getConfig().getInt("space.segganesson-chance", 0, 100));
                method.invoke(null, Material.WAXED_WEATHERED_CUT_COPPER_STAIRS, Items.SEGGANESSON_METEOR, this.getConfig().getInt("space.segganesson-chance", 0, 100));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void disable() {
        instance = null;
    }

    @EventHandler
    public void onPlayerJoin(@Nonnull PlayerJoinEvent e) {
        Player p = e.getPlayer();
        ItemStack boots = p.getInventory().getBoots();
        if (p.getAllowFlight() && SlimefunItem.getByItem((ItemStack)boots) instanceof PowerSuit && Sets.newHashSet((Object[])PowerSuit.getModules(boots)).contains((Object)Module.MINI_JETS)) {
            flying.add(p.getUniqueId());
        }
    }

    @EventHandler
    public void onPlayerLeave(@Nonnull PlayerQuitEvent e) {
        flying.remove(e.getPlayer().getUniqueId());
    }

    private static void process(ItemStack stack, Module[] modules, PowerSuit suit, Player p) {
        UUID uuid = p.getUniqueId();
        block4: for (Module module : modules) {
            PotionEffect effect = module.getEffect();
            if (effect != null && suit.getItemCharge(stack) >= (float)module.getPower()) {
                p.addPotionEffect(effect);
                suit.removeItemCharge(stack, module.getPower());
            }
            switch (module) {
                case MINI_JETS: {
                    if (!p.getAllowFlight()) {
                        p.setAllowFlight(true);
                        flying.add(uuid);
                    }
                    if (!p.isFlying()) continue block4;
                    if (suit.getItemCharge(stack) < (float)module.getPower()) {
                        p.setAllowFlight(false);
                        flying.remove(uuid);
                        continue block4;
                    }
                    suit.removeItemCharge(stack, module.getPower());
                    continue block4;
                }
                case AUXILIARY_GENERATOR: {
                    suit.addItemCharge(stack, module.getPower());
                }
            }
        }
        if (suit.getType() == ArmorPiece.FEET && flying.contains(p.getUniqueId()) && !Sets.newHashSet((Object[])modules).contains((Object)Module.MINI_JETS)) {
            p.setAllowFlight(false);
            flying.remove(uuid);
        }
        suit.addItemCharge(stack, 5.0f);
    }

    private static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }

    public static SlimefunWarfare inst() {
        return instance;
    }
}

