/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.infinitylib.machines;

import io.github.seggan.slimefunwarfare.infinitylib.common.StackUtils;
import io.github.seggan.slimefunwarfare.infinitylib.machines.MachineInput;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.inventory.ItemStack;

final class MachineBlockRecipe {
    private final String[] strings;
    private final int[] amounts;
    final ItemStack output;

    MachineBlockRecipe(ItemStack output, ItemStack[] input) {
        this.output = output;
        HashMap<String, Integer> strings = new HashMap<String, Integer>();
        for (ItemStack item : input) {
            if (item == null || item.getType().isAir()) continue;
            String string = StackUtils.getId(item);
            if (string == null) {
                string = item.getType().name();
            }
            strings.compute(string, (k, v) -> v == null ? item.getAmount() : v + item.getAmount());
        }
        this.strings = strings.keySet().toArray(new String[0]);
        this.amounts = ArrayUtils.toPrimitive((Integer[])strings.values().toArray(new Integer[0]));
    }

    boolean check(Map<String, MachineInput> map) {
        for (int i = 0; i < this.strings.length; ++i) {
            MachineInput input = map.get(this.strings[i]);
            if (input != null && input.amount >= this.amounts[i]) continue;
            return false;
        }
        return true;
    }

    void consume(Map<String, MachineInput> map) {
        block0: for (int i = 0; i < this.strings.length; ++i) {
            int consume = this.amounts[i];
            for (ItemStack item : map.get((Object)this.strings[i]).items) {
                int amt = item.getAmount();
                if (amt >= consume) {
                    item.setAmount(amt - consume);
                    continue block0;
                }
                item.setAmount(0);
                consume -= amt;
            }
        }
    }
}

