/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.machines;

import io.github.seggan.slimefunwarfare.infinitylib.common.StackUtils;
import io.github.seggan.slimefunwarfare.infinitylib.machines.AbstractMachineBlock;
import io.github.seggan.slimefunwarfare.infinitylib.machines.MenuBlock;
import io.github.seggan.slimefunwarfare.lists.Categories;
import io.github.seggan.slimefunwarfare.lists.Items;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineProcessHolder;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineOperation;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineProcessor;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public class IonExchangeSeparator
extends AbstractMachineBlock
implements EnergyNetComponent,
MachineProcessHolder<Operation> {
    private static final ItemStack NONE = new CustomItemStack(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
    private static final int[] BACKGROUND = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 13, 31, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    private static final int[] INPUT = new int[]{9, 10, 11, 12, 18, 21, 27, 28, 29, 30};
    private static final int[] OUTPUT = new int[]{14, 15, 16, 17, 23, 26, 32, 33, 34, 35};
    private final MachineProcessor<Operation> processor = new MachineProcessor((MachineProcessHolder)this);
    private final List<ItemStack> results = new ArrayList<ItemStack>();

    public IonExchangeSeparator() {
        super(Categories.MACHINES, Items.ION_EXCHANGE_SEPARATOR, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{Items.REINFORCED_SLIMESTEEL, SlimefunItems.ELECTRO_MAGNET, Items.REINFORCED_SLIMESTEEL, SlimefunItems.SULFATE, null, SlimefunItems.SULFATE, Items.REINFORCED_SLIMESTEEL, SlimefunItems.ELECTRO_MAGNET, Items.REINFORCED_SLIMESTEEL});
        this.processor.setProgressBar(new ItemStack(Material.IRON_PICKAXE));
        this.results.add((ItemStack)Items.LANTHANUM_INGOT);
        this.results.add((ItemStack)Items.NEODYMIUM_INGOT);
        this.results.add((ItemStack)Items.GADOLINIUM_INGOT);
        this.results.add((ItemStack)Items.TERBIUM_INGOT);
        this.results.add((ItemStack)Items.DYSPROSIUM_INGOT);
        this.results.add((ItemStack)Items.HOLMIUM_INGOT);
        this.results.add((ItemStack)Items.ERBIUM_INGOT);
        this.results.add((ItemStack)Items.YTTERBIUM_INGOT);
        SlimefunItem cerium = SlimefunItem.getById((String)"MATERIAL_BASTNAESITE_INGOT");
        if (cerium != null) {
            this.results.add(cerium.getItem());
        }
        this.processor.setProgressBar(new ItemStack(Material.PRISMARINE_CRYSTALS));
    }

    @Nonnull
    public MachineProcessor<Operation> getMachineProcessor() {
        return this.processor;
    }

    @Override
    @ParametersAreNonnullByDefault
    protected boolean process(Block b, BlockMenu menu) {
        Operation operation = (Operation)this.processor.getOperation(b);
        if (operation != null) {
            if (operation.isFinished()) {
                this.processor.updateProgressBar(menu, 22, (MachineOperation)operation);
                menu.pushItem(operation.getResult(), this.getInputSlots());
                this.processor.endOperation(b);
            } else {
                this.processor.updateProgressBar(menu, 22, (MachineOperation)operation);
                operation.addProgress(100);
            }
        } else {
            for (int i : this.getInputSlots()) {
                ItemStack item = menu.getItemInSlot(i);
                if (item == null || !Objects.equals(StackUtils.getId(item), Items.MONAZITE.getItemId())) continue;
                menu.consumeItem(i);
                this.processor.startOperation(b, (MachineOperation)new Operation(this.results.get(ThreadLocalRandom.current().nextInt(this.results.size())).clone()));
                break;
            }
        }
        return true;
    }

    @Override
    protected int getStatusSlot() {
        return 22;
    }

    @Override
    protected void setup(@Nonnull BlockMenuPreset preset) {
        preset.drawBackground(BACKGROUND);
        for (int i : INPUT) {
            preset.addItem(i, MenuBlock.INPUT_BORDER, ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : OUTPUT) {
            preset.addItem(i, MenuBlock.OUTPUT_BORDER, ChestMenuUtils.getEmptyClickHandler());
        }
    }

    @Override
    public int[] getInputSlots() {
        return new int[]{19, 20};
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{24, 25};
    }

    protected static final class Operation
    implements MachineOperation {
        private final ItemStack result;
        private int ticks = 0;

        protected Operation(ItemStack result) {
            this.result = result;
        }

        public void addProgress(int ticks) {
            this.ticks += ticks;
        }

        public int getProgress() {
            return this.ticks;
        }

        public int getTotalTicks() {
            return 600;
        }

        public ItemStack getResult() {
            return this.result;
        }
    }
}

