/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.infinitylib.machines;

import io.github.seggan.slimefunwarfare.infinitylib.machines.CraftingBlockRecipe;
import io.github.seggan.slimefunwarfare.infinitylib.machines.MachineLayout;
import io.github.seggan.slimefunwarfare.infinitylib.machines.MachineRecipeType;
import io.github.seggan.slimefunwarfare.infinitylib.machines.TickingMenuBlock;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@ParametersAreNonnullByDefault
public class CraftingBlock
extends TickingMenuBlock {
    public static final ItemStack INVALID_RECIPE = new CustomItemStack(Material.RED_STAINED_GLASS_PANE, "&cInvalid Recipe!", new String[0]);
    public static final ItemStack CLICK_TO_CRAFT = new CustomItemStack(Material.LIME_STAINED_GLASS_PANE, "&aClick To Craft!", new String[0]);
    protected MachineLayout layout = MachineLayout.CRAFTING_DEFAULT;
    private final List<CraftingBlockRecipe> recipes = new ArrayList<CraftingBlockRecipe>();

    public CraftingBlock(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Nonnull
    public final CraftingBlock addRecipe(ItemStack output, ItemStack ... inputs) {
        if (inputs.length == 0) {
            throw new IllegalArgumentException("Cannot add recipe with no input!");
        }
        CraftingBlockRecipe recipe = new CraftingBlockRecipe(output, inputs);
        this.recipes.add(recipe);
        return this;
    }

    @Nonnull
    public final CraftingBlock addRecipesFrom(MachineRecipeType recipeType) {
        recipeType.sendRecipesTo((in, out) -> this.addRecipe((ItemStack)out, (ItemStack)in));
        return this;
    }

    @Override
    protected final void setup(BlockMenuPreset preset) {
        preset.drawBackground(OUTPUT_BORDER, this.layout.outputBorder());
        preset.drawBackground(INPUT_BORDER, this.layout.inputBorder());
        preset.drawBackground(BACKGROUND_ITEM, this.layout.background());
        preset.addItem(this.layout.statusSlot(), INVALID_RECIPE, ChestMenuUtils.getEmptyClickHandler());
    }

    @Override
    protected final void onNewInstance(BlockMenu menu, Block b) {
        menu.addMenuClickHandler(this.layout.statusSlot(), (player, i, itemStack, clickAction) -> this.craft(b, menu, player));
    }

    private boolean craft(Block b, BlockMenu menu, Player p) {
        if (this.canCraft(b)) {
            ItemStack[] input = this.getInput(menu);
            CraftingBlockRecipe recipe = this.getOutput(b, input);
            if (recipe != null) {
                if (recipe.check(p)) {
                    if (menu.fits(recipe.output, this.layout.outputSlots())) {
                        ItemStack item = recipe.output.clone();
                        this.onSuccessfulCraft(b, menu, p, recipe.output);
                        menu.pushItem(item, this.layout.outputSlots());
                        recipe.consume(input);
                        this.tick(b, menu);
                    } else {
                        this.onNoRoom(p);
                    }
                }
            } else {
                this.onInvalidRecipe(p);
            }
        }
        return false;
    }

    @Override
    protected final int[] getInputSlots(DirtyChestMenu menu, ItemStack input) {
        return new int[0];
    }

    @Override
    protected final int[] getInputSlots() {
        return this.layout.inputSlots();
    }

    @Override
    protected final int[] getOutputSlots() {
        return this.layout.outputSlots();
    }

    @Override
    protected final void tick(Block b, BlockMenu menu) {
        if (menu.hasViewer()) {
            menu.replaceExistingItem(this.layout.statusSlot(), this.getStatus(b, menu));
        }
    }

    @Nonnull
    final ItemStack[] getInput(BlockMenu menu) {
        int[] slots = this.layout.inputSlots();
        ItemStack[] input = new ItemStack[slots.length];
        for (int i = 0; i < slots.length; ++i) {
            input[i] = menu.getItemInSlot(slots[i]);
        }
        return input;
    }

    @Nullable
    final CraftingBlockRecipe getOutput(Block b, ItemStack[] input) {
        for (CraftingBlockRecipe recipe : this.recipes) {
            if (!recipe.check(input)) continue;
            return recipe;
        }
        return null;
    }

    @Nonnull
    protected ItemStack getStatus(Block b, BlockMenu menu) {
        if (this.getOutput(b, this.getInput(menu)) == null) {
            return INVALID_RECIPE;
        }
        return CLICK_TO_CRAFT;
    }

    protected boolean canCraft(Block b) {
        return true;
    }

    protected void onInvalidRecipe(Player p) {
    }

    protected void onNoRoom(Player p) {
    }

    protected void onSuccessfulCraft(Block b, BlockMenu menu, Player p, ItemStack output) {
    }

    @Nonnull
    public CraftingBlock layout(MachineLayout layout) {
        this.layout = layout;
        return this;
    }
}

