/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.infinitylib.items;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.reflection.ReflectionUtils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public final class StackUtils {
    private static final NamespacedKey ID_KEY;
    private static final Function<Object, String> TO_STRING;
    private static final Function<Object, Object> GET_NAME;
    private static final Function<ItemStack, Object> COPY;

    @Nonnull
    public static String getIDorType(@Nonnull ItemStack item) {
        String id = StackUtils.getID(item);
        if (id == null) {
            return item.getType().toString();
        }
        return id;
    }

    @Nonnull
    public static String getIDorType(@Nonnull ItemStack item, @Nonnull ItemMeta meta) {
        String id = StackUtils.getID(meta);
        if (id == null) {
            return item.getType().toString();
        }
        return id;
    }

    @Nullable
    public static String getID(@Nonnull ItemStack item) {
        if (item instanceof SlimefunItemStack) {
            return ((SlimefunItemStack)item).getItemId();
        }
        return item.hasItemMeta() ? StackUtils.getID(item.getItemMeta()) : null;
    }

    @Nullable
    public static String getID(@Nonnull ItemMeta meta) {
        return (String)meta.getPersistentDataContainer().get(ID_KEY, PersistentDataType.STRING);
    }

    @Nullable
    public static ItemStack getItemByID(@Nonnull String id) {
        return StackUtils.getItemByID(id, 1);
    }

    @Nullable
    public static ItemStack getItemByID(@Nonnull String id, int amount) {
        SlimefunItem sfItem = SlimefunItem.getByID((String)id);
        if (sfItem != null) {
            return new CustomItem(sfItem.getItem(), amount);
        }
        return null;
    }

    @Nonnull
    public static ItemStack[] arrayFrom(@Nonnull DirtyChestMenu menu, int[] slots) {
        ItemStack[] arr = new ItemStack[slots.length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = menu.getItemInSlot(slots[i]);
        }
        return arr;
    }

    @Nullable
    public static ItemStack getItemByIDorType(@Nonnull String id) {
        return StackUtils.getItemByIDorType(id, 1);
    }

    @Nullable
    public static ItemStack getItemByIDorType(@Nonnull String id, int amount) {
        SlimefunItem sfItem = SlimefunItem.getByID((String)id);
        if (sfItem != null) {
            return new CustomItem(sfItem.getItem(), amount);
        }
        Material material = Material.getMaterial((String)id);
        if (material != null) {
            return new ItemStack(material, amount);
        }
        return null;
    }

    @Nonnull
    public static ItemStack addLore(@Nonnull ItemStack item, String ... lines) {
        ItemMeta meta = item.getItemMeta();
        ArrayList<String> lore = meta.hasLore() ? meta.getLore() : new ArrayList<String>();
        for (String line : lines) {
            lore.add(ChatColors.color((String)line));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public static String getDisplayName(@Nonnull ItemStack item) {
        return TO_STRING.apply(GET_NAME.apply(COPY.apply(item)));
    }

    public static String getDisplayName(@Nonnull ItemStack item, @Nonnull ItemMeta meta) {
        if (meta.hasDisplayName()) {
            return meta.getDisplayName();
        }
        return StackUtils.getDisplayName(item);
    }

    private static <T, V> Function<T, V> lambdaItemUtilsMethod(String name) throws Throwable {
        Field field = ItemUtils.class.getDeclaredField(name);
        field.setAccessible(true);
        Method method = (Method)field.get(null);
        method.setAccessible(true);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle handle = lookup.unreflect(method);
        return LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), handle, handle.type()).getTarget().invokeExact();
    }

    private StackUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        Function<Object, Object> copy;
        Function<Object, Object> getName;
        Function<Object, String> toString;
        ID_KEY = SlimefunPlugin.getItemDataService().getKey();
        if (ReflectionUtils.isUnitTestEnvironment()) {
            toString = obj -> "TESTING";
            getName = obj -> obj;
            copy = obj -> obj;
        } else {
            try {
                toString = StackUtils.lambdaItemUtilsMethod("toString");
                getName = StackUtils.lambdaItemUtilsMethod("getName");
                copy = StackUtils.lambdaItemUtilsMethod("copy");
            }
            catch (Throwable e) {
                e.printStackTrace();
                toString = obj -> "ERROR";
                getName = obj -> obj;
                copy = obj -> obj;
            }
        }
        TO_STRING = toString;
        GET_NAME = getName;
        COPY = copy;
    }
}

