/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.machines;

import io.github.seggan.slimefunwarfare.SlimefunWarfare;
import io.github.seggan.slimefunwarfare.infinitylib.configuration.AddonConfig;
import io.github.seggan.slimefunwarfare.infinitylib.players.CoolDownMap;
import io.github.seggan.slimefunwarfare.lists.Categories;
import io.github.seggan.slimefunwarfare.lists.Items;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MeteorAttractor
extends SimpleSlimefunItem<BlockUseHandler> {
    private static final CoolDownMap cooldowns = new CoolDownMap(60000L * (long)SlimefunWarfare.inst().getConfig().getInt("space.attractor-cooldown", 1));

    public MeteorAttractor() {
        super(Categories.MACHINES, Items.METEOR_ATTRACTOR, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{Items.NDFEB_ALLOY_BLOCK, null, Items.NDFEB_ALLOY_BLOCK, Items.NDFEB_ALLOY_BLOCK, null, Items.NDFEB_ALLOY_BLOCK, Items.TERFENOL_D_BLOCK, Items.NDFEB_ALLOY_BLOCK, Items.TERFENOL_D_BLOCK});
    }

    private void drop(Location l, Player p) {
        Block b = l.getBlock();
        if (!SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, b, ProtectableAction.BREAK_BLOCK)) {
            return;
        }
        AddonConfig config = SlimefunWarfare.inst().getConfig();
        int radius = config.getInt("space.meteor-drop-radius", 100);
        int x = ThreadLocalRandom.current().nextInt(b.getX() - radius, b.getX() + radius + 1);
        int z = ThreadLocalRandom.current().nextInt(b.getZ() - radius, b.getZ() + radius + 1);
        World world = b.getWorld();
        world.createExplosion((double)x, (double)world.getHighestBlockYAt(x, z), (double)z, 4.0f);
        SlimefunWarfare.inst().runSync(() -> {
            Block landing;
            SlimefunItemStack stack = Items.OSMIUM_METEOR;
            if (ThreadLocalRandom.current().nextInt(100) < config.getInt("space.segganesson-chance", 0, 100)) {
                stack = Items.SEGGANESSON_METEOR;
            }
            if (!(landing = world.getHighestBlockAt(x, z)).isPassable()) {
                landing = landing.getRelative(BlockFace.UP);
            }
            landing.setType(stack.getType());
            BlockStorage.addBlockInfo((Block)landing, (String)"id", (String)stack.getItemId());
        }, 2L);
    }

    @Nonnull
    public BlockUseHandler getItemHandler() {
        return b -> {
            AddonConfig config = SlimefunWarfare.inst().getConfig();
            if (cooldowns.check(b.getPlayer().getUniqueId())) {
                cooldowns.reset(b.getPlayer().getUniqueId());
                int mins = ThreadLocalRandom.current().nextInt(config.getInt("space.meteor-min-time", 10), config.getInt("space.meteor-max-time", 30) + 1);
                Location l = ((Block)b.getClickedBlock().get()).getLocation();
                b.getPlayer().sendMessage("Sending meteor in " + mins + " minutes");
                SlimefunWarfare.inst().runSync(() -> this.drop(l, b.getPlayer()), (long)(mins * 60) * 20L);
            } else {
                b.getPlayer().sendMessage(ChatColor.RED + "The Meteor Attractor has a " + config.getInt("space.space.attractor-cooldown", 1) + " minute cooldown");
            }
        };
    }
}

