/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.infinitylib;

import io.github.seggan.slimefunwarfare.infinitylib.bstats.bukkit.Metrics;
import io.github.seggan.slimefunwarfare.infinitylib.bstats.charts.SimplePie;
import io.github.seggan.slimefunwarfare.infinitylib.commands.AbstractCommand;
import io.github.seggan.slimefunwarfare.infinitylib.commands.CommandUtils;
import io.github.seggan.slimefunwarfare.infinitylib.configuration.AddonConfig;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.GitHubBuildsUpdater;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;

public abstract class AbstractAddon
extends JavaPlugin
implements SlimefunAddon {
    private final boolean notTesting;
    private boolean officialBuild;
    private String bugTrackerURL;
    private AddonConfig config;
    private int globalTick;

    public AbstractAddon() {
        this.notTesting = true;
    }

    @ParametersAreNonnullByDefault
    public AbstractAddon(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file) {
        super(loader, description, dataFolder, file);
        this.notTesting = false;
    }

    public final void onEnable() {
        block17: {
            block16: {
                String githubPath = this.getGithubPath();
                if (!githubPath.matches("[\\w-]+/[\\w-]+/[\\w-]+")) {
                    throw new IllegalStateException("Invalid Github Path '" + githubPath + "', It should be 'User/Repo/branch'!");
                }
                String userSlashRepo = githubPath.substring(0, githubPath.lastIndexOf(47));
                this.bugTrackerURL = "https://github.com/" + userSlashRepo + "/issues";
                this.officialBuild = this.getDescription().getVersion().matches("DEV - \\d+ \\(git \\w+\\)");
                try {
                    this.config = new AddonConfig(this, "config.yml");
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (this.isOfficialBuild() && this.getAutoUpdatePath() != null) {
                        new GitHubBuildsUpdater((Plugin)this, this.getFile(), githubPath).start();
                    }
                    return;
                }
                if (this.isOfficialBuild()) {
                    Metrics metrics;
                    block15: {
                        metrics = null;
                        try {
                            metrics = this.setupMetrics();
                        }
                        catch (Throwable e) {
                            if (!this.isNotTesting()) break block15;
                            e.printStackTrace();
                        }
                    }
                    if (this.getAutoUpdatePath() != null) {
                        boolean autoUpdate = this.config.getBoolean(this.getAutoUpdatePath());
                        if (metrics != null) {
                            String autoUpdates = String.valueOf(autoUpdate);
                            metrics.addCustomChart(new SimplePie("auto_updates", () -> autoUpdates));
                        }
                        if (autoUpdate) {
                            new GitHubBuildsUpdater((Plugin)this, this.getFile(), githubPath).start();
                        }
                    }
                }
                try {
                    this.enable();
                }
                catch (Throwable e) {
                    if (!this.isNotTesting()) break block16;
                    e.printStackTrace();
                }
            }
            try {
                List<AbstractCommand> subCommands = this.setupSubCommands();
                if (subCommands != null) {
                    CommandUtils.addSubCommands(this, this.getCommandName(), subCommands);
                }
            }
            catch (Throwable e) {
                if (!this.isNotTesting()) break block17;
                e.printStackTrace();
            }
        }
        this.scheduleRepeatingSync(() -> ++this.globalTick, SlimefunPlugin.getTickerTask().getTickRate());
    }

    public final void onDisable() {
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        this.disable();
    }

    protected abstract void enable();

    protected abstract void disable();

    @Nonnull
    protected abstract String getGithubPath();

    @Nullable
    protected Metrics setupMetrics() {
        return null;
    }

    @Nullable
    protected List<AbstractCommand> setupSubCommands() {
        return null;
    }

    @Nonnull
    protected String getCommandName() {
        return this.getName();
    }

    @Nullable
    public abstract String getAutoUpdatePath();

    public final int getGlobalTick() {
        return this.globalTick;
    }

    public final boolean isNotTesting() {
        return this.notTesting;
    }

    public final boolean isOfficialBuild() {
        return this.officialBuild;
    }

    @Nonnull
    public final JavaPlugin getJavaPlugin() {
        return this;
    }

    @Nonnull
    public final String getBugTrackerURL() {
        return this.bugTrackerURL;
    }

    @Nonnull
    public final AddonConfig getConfig() {
        return this.config;
    }

    public final void reloadConfig() {
        this.config.reload();
    }

    public final void saveConfig() {
        this.config.save();
    }

    public final void saveDefaultConfig() {
    }

    public final void log(String ... messages) {
        this.log(Level.INFO, messages);
    }

    public final void log(Level level, String ... messages) {
        Logger logger = this.getLogger();
        for (String msg : messages) {
            logger.log(level, msg);
        }
    }

    public final void registerListener(Listener ... listeners) {
        PluginManager manager = Bukkit.getPluginManager();
        for (Listener listener : listeners) {
            manager.registerEvents(listener, (Plugin)this);
        }
    }

    public final NamespacedKey getKey(String s) {
        return new NamespacedKey((Plugin)this, s);
    }

    public final void runSync(Runnable runnable) {
        Bukkit.getScheduler().runTask((Plugin)this, runnable);
    }

    public final void runSync(Runnable runnable, long delay) {
        Bukkit.getScheduler().runTaskLater((Plugin)this, runnable, delay);
    }

    public final void scheduleRepeatingSync(Runnable runnable, long interval) {
        Bukkit.getScheduler().runTaskTimer((Plugin)this, runnable, 0L, interval);
    }

    public final void scheduleRepeatingSync(Runnable runnable, long delay, long interval) {
        Bukkit.getScheduler().runTaskTimer((Plugin)this, runnable, delay, interval);
    }

    public final void runAsync(Runnable runnable) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, runnable);
    }

    public final void runAsync(Runnable runnable, long delay) {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, runnable, delay);
    }

    public final void scheduleRepeatingAsync(Runnable runnable, long interval) {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, runnable, 0L, interval);
    }

    public final void scheduleRepeatingAsync(Runnable runnable, long delay, long interval) {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, runnable, delay, interval);
    }
}

