/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.machines;

import io.github.seggan.slimefunwarfare.infinitylib.items.StackUtils;
import io.github.seggan.slimefunwarfare.infinitylib.presets.MenuPreset;
import io.github.seggan.slimefunwarfare.infinitylib.slimefun.AbstractTickingContainer;
import io.github.seggan.slimefunwarfare.lists.Categories;
import io.github.seggan.slimefunwarfare.lists.Items;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineProcessHolder;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineOperation;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineProcessor;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public class IonExchangeSeparator
extends AbstractTickingContainer
implements EnergyNetComponent,
MachineProcessHolder<Operation> {
    private static final int[] BACKGROUND = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 13, 31, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    private static final int[] INPUT_BORDER = new int[]{9, 10, 11, 12, 18, 21, 27, 28, 29, 30};
    private static final int[] OUTPUT_BORDER = new int[]{14, 15, 16, 17, 23, 26, 32, 33, 34, 35};
    private static final int[] INPUT = new int[]{19, 20};
    private static final int[] OUTPUT = new int[]{24, 25};
    private static final ItemStack NONE = new CustomItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
    private final MachineProcessor<Operation> processor = new MachineProcessor((MachineProcessHolder)this);
    private final List<ItemStack> results = new ArrayList<ItemStack>();

    public IonExchangeSeparator() {
        super(Categories.MACHINES, Items.ION_EXCHANGE_SEPARATOR, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{Items.REINFORCED_SLIMESTEEL, SlimefunItems.ELECTRO_MAGNET, Items.REINFORCED_SLIMESTEEL, SlimefunItems.SULFATE, null, SlimefunItems.SULFATE, Items.REINFORCED_SLIMESTEEL, SlimefunItems.ELECTRO_MAGNET, Items.REINFORCED_SLIMESTEEL});
        this.processor.setProgressBar(new ItemStack(Material.IRON_PICKAXE));
        this.results.add((ItemStack)Items.LANTHANUM_INGOT);
        this.results.add((ItemStack)Items.NEODYMIUM_INGOT);
        this.results.add((ItemStack)Items.GADOLINIUM_INGOT);
        this.results.add((ItemStack)Items.TERBIUM_INGOT);
        this.results.add((ItemStack)Items.DYSPROSIUM_INGOT);
        this.results.add((ItemStack)Items.HOLMIUM_INGOT);
        this.results.add((ItemStack)Items.ERBIUM_INGOT);
        this.results.add((ItemStack)Items.YTTERBIUM_INGOT);
        SlimefunItem cerium = SlimefunItem.getByID((String)"MATERIAL_BASTNAESITE_INGOT");
        if (cerium != null) {
            this.results.add(cerium.getItem());
        }
        this.addItemHandler(new ItemHandler[]{this.onBreak()});
    }

    @Override
    protected void tick(@Nonnull BlockMenu menu, @Nonnull Block b) {
        block4: {
            block3: {
                Operation operation = (Operation)this.processor.getOperation(b);
                if (operation == null) break block3;
                int charge = this.getCharge(b.getLocation());
                if (charge <= 128) break block4;
                this.removeCharge(b.getLocation(), 128);
                if (operation.isFinished()) {
                    menu.replaceExistingItem(22, NONE);
                    menu.pushItem(operation.getResult(), OUTPUT);
                    this.processor.endOperation(b);
                } else {
                    this.processor.updateProgressBar(menu, 22, (MachineOperation)operation);
                    operation.addProgress(1);
                }
                break block4;
            }
            for (int i : INPUT) {
                ItemStack item = menu.getItemInSlot(i);
                if (item == null || !Objects.equals(StackUtils.getID(item), Items.MONAZITE.getItemId())) continue;
                menu.consumeItem(i);
                this.processor.startOperation(b, (MachineOperation)new Operation(this.results.get(ThreadLocalRandom.current().nextInt(this.results.size())).clone()));
                break;
            }
        }
    }

    @Override
    protected void setupMenu(@Nonnull BlockMenuPreset preset) {
        preset.drawBackground(BACKGROUND);
        for (int i : INPUT_BORDER) {
            preset.addItem(i, MenuPreset.INPUT_ITEM, ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : OUTPUT_BORDER) {
            preset.addItem(i, MenuPreset.OUTPUT_ITEM, ChestMenuUtils.getEmptyClickHandler());
        }
        preset.addItem(22, NONE, ChestMenuUtils.getEmptyClickHandler());
    }

    @Override
    @Nonnull
    protected int[] getTransportSlots(@Nonnull DirtyChestMenu menu, @Nonnull ItemTransportFlow flow, ItemStack item) {
        if (flow == ItemTransportFlow.INSERT) {
            return INPUT;
        }
        return OUTPUT;
    }

    @Nonnull
    public MachineProcessor<Operation> getMachineProcessor() {
        return this.processor;
    }

    @Nonnull
    protected BlockBreakHandler onBreak() {
        return new SimpleBlockBreakHandler(){

            public void onBlockBreak(@Nonnull Block b) {
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), INPUT);
                    inv.dropItems(b.getLocation(), OUTPUT);
                }
                IonExchangeSeparator.this.processor.endOperation(b);
            }
        };
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return 512;
    }

    protected static final class Operation
    implements MachineOperation {
        private final ItemStack result;
        private int ticks = 0;

        protected Operation(ItemStack result) {
            this.result = result;
        }

        public void addProgress(int ticks) {
            this.ticks += ticks;
        }

        public int getProgress() {
            return this.ticks;
        }

        public int getTotalTicks() {
            return 600;
        }

        public ItemStack getResult() {
            return this.result;
        }
    }
}

