/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.items.powersuits;

import io.github.seggan.slimefunwarfare.SlimefunWarfare;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dispenser;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Piston;
import org.bukkit.block.data.type.PistonHead;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ElementForge
extends MultiBlockMachine {
    public ElementForge(Category category, SlimefunItemStack item) {
        super(category, item, new ItemStack[]{ElementForge.getCorner(), new CustomItem(Material.PISTON, "&fPiston &7(Facing Down)", new String[0]), ElementForge.getCorner(), new ItemStack(Material.NETHER_BRICK_WALL), null, new ItemStack(Material.NETHER_BRICK_WALL), new CustomItem(Material.HOPPER, "&fHopper &7(Facing Inwards)", new String[0]), new ItemStack(Material.SMITHING_TABLE), new ItemStack(Material.DISPENSER)}, BlockFace.UP);
    }

    @Nonnull
    private static ItemStack getCorner() {
        if (SlimefunWarfare.inst().getConfig().getBoolean("suits.legacy-element-forge", false)) {
            return new ItemStack(Material.IRON_BLOCK);
        }
        return new ItemStack(Material.NETHERITE_BLOCK);
    }

    public void onInteract(Player p, Block b) {
        Block dispenser = this.locateDispenser(b);
        Block piston = b.getRelative(0, 2, 0);
        if (dispenser == null) {
            p.sendMessage(ChatColor.RED + "Could not locate dispenser!");
            return;
        }
        BlockState dispenserState = PaperLib.getBlockState((Block)dispenser, (boolean)false).getState();
        BlockData pistonData = piston.getBlockData();
        if (dispenserState instanceof Dispenser && pistonData instanceof Piston && ((Piston)pistonData).getFacing() == BlockFace.DOWN && piston.getRelative(0, -1, 0).getType() == Material.AIR) {
            Dispenser disp = (Dispenser)dispenserState;
            Piston pstn = (Piston)pistonData;
            Inventory inv = disp.getInventory();
            List inputs = RecipeType.getRecipeInputList((MultiBlockMachine)this);
            for (ItemStack[] input : inputs) {
                if (!this.isCraftable(inv, input)) continue;
                ItemStack output = RecipeType.getRecipeOutputList((MultiBlockMachine)this, (ItemStack[])input).clone();
                if (SlimefunUtils.canPlayerUseItem((Player)p, (ItemStack)output, (boolean)true)) {
                    Inventory outputInv = this.findOutputInventory(output, dispenser, inv);
                    if (outputInv != null) {
                        this.craft(output, inv, outputInv);
                        this.movePiston(piston, pstn, true);
                        SlimefunWarfare.inst().runSync(() -> this.movePiston(piston, pstn, false), 10L);
                    } else {
                        SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.full-inventory", true);
                    }
                }
                return;
            }
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.pattern-not-found", true);
        }
    }

    private boolean isCraftable(Inventory inv, ItemStack[] recipe) {
        for (int j = 0; j < inv.getContents().length; ++j) {
            if (SlimefunUtils.isItemSimilar((ItemStack)inv.getContents()[j], (ItemStack)recipe[j], (boolean)true, (boolean)false)) continue;
            return false;
        }
        return true;
    }

    private void craft(ItemStack output, Inventory inv, Inventory outputInv) {
        for (int j = 0; j < 9; ++j) {
            ItemStack item = inv.getContents()[j];
            if (item.getType() == Material.AIR) continue;
            ItemUtils.consumeItem((ItemStack)item, (boolean)true);
        }
        outputInv.addItem(new ItemStack[]{output});
    }

    private Block locateDispenser(Block b) {
        Function<Block, Boolean> func = block -> block.getType() == Material.DISPENSER;
        if (func.apply(b.getRelative(1, 0, 0)).booleanValue()) {
            return b.getRelative(1, 0, 0);
        }
        if (func.apply(b.getRelative(0, 0, 1)).booleanValue()) {
            return b.getRelative(0, 0, 1);
        }
        if (func.apply(b.getRelative(-1, 0, 0)).booleanValue()) {
            return b.getRelative(-1, 0, 0);
        }
        if (func.apply(b.getRelative(0, 0, -1)).booleanValue()) {
            return b.getRelative(0, 0, -1);
        }
        return null;
    }

    private void movePiston(Block piston, Piston pistn, boolean extended) {
        pistn.setExtended(extended);
        piston.setBlockData((BlockData)pistn, false);
        if (extended) {
            PistonHead head = (PistonHead)Material.PISTON_HEAD.createBlockData();
            head.setFacing(BlockFace.DOWN);
            piston.getRelative(BlockFace.DOWN).setBlockData((BlockData)head, false);
            piston.getWorld().playSound(piston.getLocation(), Sound.BLOCK_PISTON_CONTRACT, 0.5f, 0.5f);
        } else {
            piston.getRelative(BlockFace.DOWN).setType(Material.AIR);
        }
    }
}

