/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.infinitylib.recipes;

import io.github.seggan.slimefunwarfare.infinitylib.recipes.AbstractRecipe;
import io.github.seggan.slimefunwarfare.infinitylib.recipes.RecipeOutput;
import io.github.seggan.slimefunwarfare.infinitylib.recipes.RecipeType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.inventory.ItemStack;

public final class RecipeMap<O> {
    private final Map<AbstractRecipe, O> recipes = new ConcurrentHashMap<AbstractRecipe, O>();
    private final RecipeType type;

    public void put(@Nonnull ItemStack[] rawInput, @Nonnull O output) {
        this.recipes.put((AbstractRecipe)this.type.apply(rawInput), output);
    }

    @Nullable
    public RecipeOutput<O> get(@Nonnull ItemStack[] rawInput) {
        AbstractRecipe input = (AbstractRecipe)this.type.apply(rawInput);
        O output = this.recipes.get(input);
        if (output != null) {
            return new RecipeOutput<O>(output, input);
        }
        return null;
    }

    @Nullable
    public O getAndConsume(@Nonnull ItemStack[] rawInput) {
        AbstractRecipe input = (AbstractRecipe)this.type.apply(rawInput);
        O output = this.recipes.get(input);
        if (output != null) {
            input.consumeMatchingRecipe();
            return output;
        }
        return null;
    }

    @Nullable
    public O getNoConsume(@Nonnull ItemStack[] rawInput) {
        return this.recipes.get(this.type.apply(rawInput));
    }

    public RecipeMap(RecipeType type) {
        this.type = type;
    }
}

