/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.infinitylib.recipes.small;

import io.github.seggan.slimefunwarfare.infinitylib.items.FastItemStack;
import io.github.seggan.slimefunwarfare.infinitylib.recipes.small.SmallOutput;
import io.github.seggan.slimefunwarfare.infinitylib.recipes.small.SmallRecipe;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.inventory.ItemStack;

public final class SmallRecipeMap<O> {
    private final Map<SmallRecipe, O> recipes = new ConcurrentHashMap<SmallRecipe, O>();

    public void put(@Nonnull ItemStack rawInput, @Nonnull O output) {
        this.recipes.put(this.toRecipe(rawInput), output);
    }

    @Nullable
    public SmallOutput<O> get(@Nonnull ItemStack rawInput) {
        SmallRecipe input = this.toRecipe(rawInput);
        O output = this.recipes.get(input);
        if (output != null) {
            return new SmallOutput<O>(output, input);
        }
        return null;
    }

    @Nullable
    public O getAndConsume(@Nonnull ItemStack rawInput) {
        SmallRecipe input = this.toRecipe(rawInput);
        O output = this.recipes.get(input);
        if (output != null) {
            input.consume();
            return output;
        }
        return null;
    }

    @Nullable
    public O getNoConsume(@Nonnull ItemStack rawInput) {
        return this.recipes.get(this.toRecipe(rawInput));
    }

    @Nonnull
    private SmallRecipe toRecipe(@Nonnull ItemStack rawInput) {
        return new SmallRecipe(FastItemStack.of(rawInput));
    }
}

