/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.infinitylib.items;

import io.github.seggan.slimefunwarfare.infinitylib.items.FastItemStack;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public final class StackUtils {
    private static final NamespacedKey KEY = SlimefunPlugin.getItemDataService().getKey();
    private static Method COPY;
    private static Method GET_NAME;
    private static Method TO_STRING;

    @Nonnull
    public static String getIDorType(@Nonnull ItemStack item) {
        String id = StackUtils.getID(item);
        if (id == null) {
            return item.getType().toString();
        }
        return id;
    }

    @Nonnull
    public static String getIDorType(@Nonnull ItemStack item, @Nonnull ItemMeta meta) {
        String id = StackUtils.getID(meta);
        if (id == null) {
            return item.getType().toString();
        }
        return id;
    }

    @Nullable
    public static String getID(@Nonnull ItemStack item) {
        if (item instanceof SlimefunItemStack) {
            return ((SlimefunItemStack)item).getItemId();
        }
        if (item instanceof FastItemStack) {
            return ((FastItemStack)item).getID();
        }
        if (!item.hasItemMeta()) {
            return null;
        }
        return StackUtils.getID(item.getItemMeta());
    }

    @Nullable
    public static String getID(@Nonnull ItemMeta meta) {
        return (String)meta.getPersistentDataContainer().get(KEY, PersistentDataType.STRING);
    }

    @Nullable
    public static ItemStack getItemByID(@Nonnull String id) {
        return StackUtils.getItemByID(id, 1);
    }

    @Nullable
    public static ItemStack getItemByID(@Nonnull String id, int amount) {
        SlimefunItem sfItem = SlimefunItem.getByID((String)id);
        if (sfItem != null) {
            return new CustomItem(sfItem.getItem(), amount);
        }
        return null;
    }

    @Nullable
    public static ItemStack getItemByIDorType(@Nonnull String id) {
        return StackUtils.getItemByIDorType(id, 1);
    }

    @Nullable
    public static ItemStack getItemByIDorType(@Nonnull String id, int amount) {
        SlimefunItem sfItem = SlimefunItem.getByID((String)id);
        if (sfItem != null) {
            return new CustomItem(sfItem.getItem(), amount);
        }
        Material material = Material.getMaterial((String)id);
        if (material != null) {
            return new ItemStack(material, amount);
        }
        return null;
    }

    @Nonnull
    public static ItemStack addLore(@Nonnull ItemStack item, String ... lines) {
        ArrayList<String> lore;
        ItemMeta meta = item.getItemMeta();
        if (meta.hasLore()) {
            lore = meta.getLore();
            if (lore == null) {
                lore = new ArrayList();
            }
        } else {
            lore = new ArrayList<String>();
        }
        for (String line : lines) {
            lore.add(ChatColors.color((String)line));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public static String getInternalName(@Nonnull ItemStack item) {
        try {
            return ChatColor.WHITE + (String)TO_STRING.invoke(GET_NAME.invoke(COPY.invoke(null, item), new Object[0]), new Object[0]);
        }
        catch (Exception e) {
            return ChatColor.RED + "ERROR";
        }
    }

    public static String getDisplayName(@Nonnull ItemStack item, @Nonnull ItemMeta meta) {
        if (meta.hasDisplayName()) {
            return meta.getDisplayName();
        }
        return StackUtils.getInternalName(item);
    }

    public static String getDisplayName(@Nonnull ItemStack item) {
        ItemMeta meta;
        if (item.hasItemMeta() && (meta = item.getItemMeta()).hasDisplayName()) {
            return meta.getDisplayName();
        }
        return StackUtils.getInternalName(item);
    }

    public static ItemStack[] arrayFrom(@Nonnull DirtyChestMenu menu, int[] slots) {
        ItemStack[] arr = new ItemStack[slots.length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = menu.getItemInSlot(slots[i]);
        }
        return arr;
    }

    private StackUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        try {
            Field field = ItemUtils.class.getDeclaredField("copy");
            field.setAccessible(true);
            COPY = (Method)field.get(null);
            COPY.setAccessible(true);
            field = ItemUtils.class.getDeclaredField("getName");
            field.setAccessible(true);
            GET_NAME = (Method)field.get(null);
            GET_NAME.setAccessible(true);
            field = ItemUtils.class.getDeclaredField("toString");
            field.setAccessible(true);
            TO_STRING = (Method)field.get(null);
            TO_STRING.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

