/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.infinitylib.configuration;

import io.github.seggan.slimefunwarfare.infinitylib.AbstractAddon;
import io.github.seggan.slimefunwarfare.infinitylib.configuration.PathBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public final class AddonConfig
extends YamlConfiguration {
    private final Map<String, String> comments = new HashMap<String, String>();
    private final AbstractAddon addon;
    private final File file;

    public AddonConfig(@Nonnull AbstractAddon addon, @Nonnull String name) {
        this.file = new File(addon.getDataFolder(), name);
        this.addon = addon;
        this.loadDefaults(name);
        this.reload();
    }

    public int getInt(@Nonnull String path, int min, int max) {
        int val = this.getInt(path);
        if (val < min || val > max) {
            val = this.getDefaults().getInt(path);
            this.set(path, val);
        }
        return val;
    }

    public double getDouble(@Nonnull String path, double min, double max) {
        double val = this.getDouble(path);
        if (val < min || val > max) {
            val = this.getDefaults().getDouble(path);
            this.set(path, val);
        }
        return val;
    }

    public void save() {
        try {
            this.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reload() {
        if (this.file.exists()) {
            try {
                this.load(this.file);
            }
            catch (Exception e) {
                this.addon.log(Level.SEVERE, "There was an error loading the config '" + this.file.getPath() + "', resetting to default!");
            }
        }
        this.save();
    }

    @Nullable
    public String getComment(String key) {
        return this.comments.get(key);
    }

    @Nonnull
    public Configuration getDefaults() {
        return Objects.requireNonNull(super.getDefaults());
    }

    @Nonnull
    protected String buildHeader() {
        return "";
    }

    public void loadFromString(@Nonnull String contents) throws InvalidConfigurationException {
        super.loadFromString(contents);
        for (String key : this.getKeys(true)) {
            if (this.defaults.contains(key)) continue;
            this.set(key, null);
        }
    }

    @Nonnull
    public String saveToString() {
        this.options().copyDefaults(true).copyHeader(false).indent(2);
        String string = super.saveToString();
        String[] lines = string.split("\n");
        StringBuilder save = new StringBuilder();
        PathBuilder pathBuilder = new PathBuilder();
        for (String line : lines) {
            if (line.isEmpty()) continue;
            String comment = this.getComment(pathBuilder.append(line).build());
            if (comment != null) {
                save.append(comment);
            }
            save.append(line).append('\n');
        }
        return save.toString();
    }

    private void loadDefaults(String name) {
        String path;
        YamlConfiguration defaults = new YamlConfiguration();
        InputStream stream = this.addon.getResource(name);
        if (stream == null) {
            this.addon.log(Level.SEVERE, "No default config for " + name + "! Report this to the developers!");
        } else {
            try {
                defaults.loadFromString(this.readDefaults(stream));
            }
            catch (Exception e) {
                this.addon.log(Level.SEVERE, "An " + e.getClass().getSimpleName() + " occurred while loading the default config of '" + name + "', report it to the developers!");
                e.printStackTrace();
            }
        }
        if (name.equals("config.yml") && (path = this.addon.getAutoUpdatePath()) != null && !defaults.contains(path)) {
            defaults.set(path, (Object)true);
        }
        this.setDefaults((Configuration)defaults);
    }

    private String readDefaults(@Nonnull InputStream inputStream) throws IOException {
        String line;
        BufferedReader input = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        StringBuilder yamlBuilder = new StringBuilder();
        StringBuilder commentBuilder = new StringBuilder("\n");
        PathBuilder pathBuilder = new PathBuilder();
        while ((line = input.readLine()) != null) {
            yamlBuilder.append(line).append('\n');
            if (StringUtils.isBlank((String)line)) continue;
            if (line.contains("#")) {
                commentBuilder.append(line).append('\n');
                continue;
            }
            pathBuilder.append(line);
            if (commentBuilder.length() != 1) {
                this.comments.put(pathBuilder.build(), commentBuilder.toString());
                commentBuilder = new StringBuilder("\n");
                continue;
            }
            if (!pathBuilder.inMainSection()) continue;
            this.comments.put(pathBuilder.build(), "\n");
        }
        input.close();
        return yamlBuilder.toString();
    }
}

