/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.items.powersuits;

import io.github.seggan.slimefunwarfare.SlimefunWarfare;
import io.github.seggan.slimefunwarfare.items.powersuits.ArmorPiece;
import io.github.seggan.slimefunwarfare.items.powersuits.Module;
import io.github.seggan.slimefunwarfare.items.powersuits.PersistentModuleArray;
import io.github.seggan.slimefunwarfare.lists.Categories;
import io.github.thebusybiscuit.slimefun4.core.attributes.ProtectionType;
import io.github.thebusybiscuit.slimefun4.core.attributes.ProtectiveArmor;
import io.github.thebusybiscuit.slimefun4.core.attributes.Rechargeable;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class PowerSuit
extends SlimefunItem
implements ProtectiveArmor,
Rechargeable {
    private static final NamespacedKey MODULES = SlimefunWarfare.inst().getKey("modules");
    private final ArmorPiece type;

    public PowerSuit(SlimefunItemStack item, ItemStack[] recipe, ArmorPiece type) {
        super(Categories.POWER_SUITS, item, RecipeType.ARMOR_FORGE, recipe);
        this.type = type;
        ItemMeta meta = this.getItem().getItemMeta();
        meta.setUnbreakable(true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        this.getItem().setItemMeta(meta);
    }

    @Nonnull
    public static Module[] getModules(@Nullable ItemStack stack) {
        if (stack == null) {
            return new Module[0];
        }
        ItemMeta meta = stack.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return (Module[])container.getOrDefault(MODULES, (PersistentDataType)PersistentModuleArray.TYPE, (Object)new Module[0]);
    }

    public static void addModule(@Nonnull ItemStack stack, @Nonnull Module module) {
        ItemMeta meta = stack.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        Module[] newArr = (Module[])ArrayUtils.add((Object[])((Object[])container.getOrDefault(MODULES, (PersistentDataType)PersistentModuleArray.TYPE, (Object)new Module[0])), (Object)((Object)module));
        container.set(MODULES, (PersistentDataType)PersistentModuleArray.TYPE, (Object)newArr);
        stack.setItemMeta(meta);
    }

    @Nullable
    public static Module popModule(@Nonnull ItemStack stack) {
        ItemMeta meta = stack.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        Module[] modules = (Module[])container.getOrDefault(MODULES, (PersistentDataType)PersistentModuleArray.TYPE, (Object)new Module[0]);
        if (modules.length == 0) {
            return null;
        }
        Module module = modules[modules.length - 1];
        container.set(MODULES, (PersistentDataType)PersistentModuleArray.TYPE, (Object)Arrays.copyOf(modules, modules.length - 1));
        stack.setItemMeta(meta);
        return module;
    }

    @Nonnull
    public ProtectionType[] getProtectionTypes() {
        return ProtectionType.values();
    }

    public boolean isFullSetRequired() {
        return true;
    }

    @Nonnull
    public NamespacedKey getArmorSetId() {
        return SlimefunWarfare.inst().getKey("power_suit");
    }

    public float getMaxItemCharge(ItemStack item) {
        return 1000.0f;
    }

    public ArmorPiece getType() {
        return this.type;
    }
}

