/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.infinitylib.commands;

import io.github.seggan.slimefunwarfare.infinitylib.AbstractAddon;
import io.github.seggan.slimefunwarfare.infinitylib.commands.AbstractCommand;
import io.github.seggan.slimefunwarfare.infinitylib.commands.HelpCommand;
import io.github.seggan.slimefunwarfare.infinitylib.commands.InfoCommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;

public final class CommandUtils
implements TabExecutor {
    private final Map<String, AbstractCommand> commands = new HashMap<String, AbstractCommand>();

    public static void addSubCommands(AbstractAddon addon, String commandName, List<AbstractCommand> subCommands) {
        PluginCommand command = addon.getCommand(commandName);
        if (command == null) {
            throw new IllegalArgumentException("No such command '" + commandName + "'! Report this to the developers!");
        }
        subCommands = new ArrayList<AbstractCommand>(subCommands);
        subCommands.add(new HelpCommand(subCommands, command));
        subCommands.add(new InfoCommand(addon));
        new CommandUtils(command, subCommands);
    }

    private CommandUtils(PluginCommand command, List<AbstractCommand> subCommands) {
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)this);
        for (AbstractCommand abstractCommand : subCommands) {
            this.commands.put(abstractCommand.name, abstractCommand);
        }
    }

    public boolean onCommand(@Nonnull CommandSender sender, @Nonnull Command command, @Nonnull String label, @Nonnull String[] args) {
        AbstractCommand command1;
        if (args.length > 0 && (command1 = this.commands.get(args[0])) != null && command1.hasPerm(sender)) {
            command1.onExecute(sender, args);
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(@Nonnull CommandSender sender, @Nonnull Command command, @Nonnull String alias, String[] args) {
        AbstractCommand command1;
        if (args.length == 1) {
            ArrayList<String> strings = new ArrayList<String>();
            for (AbstractCommand command12 : this.commands.values()) {
                if (!command12.hasPerm(sender)) continue;
                strings.add(command12.name);
            }
            return CommandUtils.createReturnList(strings, args[0]);
        }
        if (args.length > 1 && (command1 = this.commands.get(args[0])) != null && command1.hasPerm(sender)) {
            ArrayList<String> strings = new ArrayList<String>();
            command1.onTab(sender, args, strings);
            return CommandUtils.createReturnList(strings, args[args.length - 1]);
        }
        return Collections.emptyList();
    }

    @Nonnull
    private static List<String> createReturnList(@Nonnull List<String> strings, @Nonnull String string) {
        String input = string.toLowerCase(Locale.ROOT);
        LinkedList<String> returnList = new LinkedList<String>();
        for (String item : strings) {
            if (item.toLowerCase(Locale.ROOT).contains(input)) {
                returnList.add(item);
                if (returnList.size() < 64) continue;
                break;
            }
            if (!item.equalsIgnoreCase(input)) continue;
            return Collections.emptyList();
        }
        return returnList;
    }
}

