/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.infinitylib.recipes;

import io.github.seggan.slimefunwarfare.infinitylib.items.FastItemStack;
import io.github.seggan.slimefunwarfare.infinitylib.recipes.AbstractRecipe;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public final class ShapelessRecipe
extends AbstractRecipe {
    private final Map<String, Integer> map = new HashMap<String, Integer>(8);

    public ShapelessRecipe(FastItemStack[] input) {
        super(input);
        for (FastItemStack item : input) {
            if (item == null) continue;
            this.map.compute(item.getIDorType(), (k, v) -> v == null ? item.getAmount() : v + item.getAmount());
        }
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (String s : this.map.keySet()) {
            hash += s.hashCode();
        }
        return hash;
    }

    @Override
    protected boolean matches(@Nonnull AbstractRecipe input) {
        Map<String, Integer> inputMap = ((ShapelessRecipe)input).map;
        for (Map.Entry<String, Integer> entry : this.map.entrySet()) {
            if (inputMap.getOrDefault(entry.getKey(), 0) >= entry.getValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void consume(@Nonnull AbstractRecipe input) {
        block0: for (Map.Entry<String, Integer> entry : this.map.entrySet()) {
            int rem = entry.getValue();
            for (FastItemStack item : input.getRawInput()) {
                if (item == null || !item.getIDorType().equals(entry.getKey())) continue;
                int amt = item.getAmount();
                if (amt >= rem) {
                    item.setAmount(amt - rem);
                    continue block0;
                }
                rem -= amt;
            }
        }
    }
}

