/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare;

import com.google.common.collect.Sets;
import io.github.seggan.slimefunwarfare.Setup;
import io.github.seggan.slimefunwarfare.Util;
import io.github.seggan.slimefunwarfare.infinitylib.AbstractAddon;
import io.github.seggan.slimefunwarfare.infinitylib.bstats.bukkit.Metrics;
import io.github.seggan.slimefunwarfare.items.guns.Gun;
import io.github.seggan.slimefunwarfare.items.powersuits.ArmorPiece;
import io.github.seggan.slimefunwarfare.items.powersuits.Module;
import io.github.seggan.slimefunwarfare.items.powersuits.PowerSuit;
import io.github.seggan.slimefunwarfare.listeners.BulletListener;
import io.github.seggan.slimefunwarfare.listeners.ConcreteListener;
import io.github.seggan.slimefunwarfare.listeners.GrenadeListener;
import io.github.seggan.slimefunwarfare.listeners.HitListener;
import io.github.seggan.slimefunwarfare.listeners.ModuleListener;
import io.github.seggan.slimefunwarfare.listeners.NukeListener;
import io.github.seggan.slimefunwarfare.listeners.PyroListener;
import io.github.seggan.slimefunwarfare.listeners.SpaceListener;
import io.github.seggan.slimefunwarfare.lists.Categories;
import io.github.seggan.slimefunwarfare.spacegenerators.SpaceGenerator;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;

public class SlimefunWarfare
extends AbstractAddon
implements Listener {
    private static SlimefunWarfare instance = null;
    private static final Set<UUID> flying = new HashSet<UUID>();

    @Override
    public void onAddonEnable() {
        instance = this;
        this.registerListener(new BulletListener(), new PyroListener(), new GrenadeListener(), new ConcreteListener(), new NukeListener(), new SpaceListener(), new HitListener(), new ModuleListener(), this);
        Categories.setup(this);
        Setup.setupItems(this);
        Setup.setupMelee(this);
        Setup.setupBullets(this);
        Setup.setupGuns(this);
        Setup.setupExplosives(this);
        Setup.setupSpace(this);
        Setup.setupSuits(this);
        Module.setup(this);
        if (SlimefunWarfare.getJavaVersion() < 11) {
            this.log(Level.WARNING, "You are using a Java version that is less that 11! Please use Java 11 or above");
        }
        for (World world : Bukkit.getWorlds()) {
            World space;
            String name = world.getName();
            if (name.endsWith("_nether") || name.endsWith("_the_end") || name.endsWith("_space") || (space = Bukkit.getWorld((String)(name + "_space"))) != null || !SlimefunPlugin.getWorldSettingsService().isWorldEnabled(world)) continue;
            WorldCreator creator = new WorldCreator(name + "_space").seed(world.getSeed()).generator((ChunkGenerator)new SpaceGenerator());
            space = creator.createWorld();
            space.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
            space.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)false);
            space.setTime(18000L);
        }
        if (this.getConfig().getBoolean("guns.autoshoot", true)) {
            this.scheduleRepeatingSync(() -> {
                for (Player p : this.getServer().getOnlinePlayers()) {
                    ItemStack stack;
                    SlimefunItem item;
                    if (!p.isSneaking() || p.isFlying() || !((item = SlimefunItem.getByItem((ItemStack)(stack = p.getInventory().getItemInMainHand()))) instanceof Gun)) continue;
                    Gun gun = (Gun)item;
                    ItemMeta meta = stack.getItemMeta();
                    PersistentDataContainer container = meta.getPersistentDataContainer();
                    long lastUse = (Long)container.getOrDefault(Gun.LAST_USE, PersistentDataType.LONG, (Object)0L);
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - lastUse < (long)gun.getCooldown()) continue;
                    container.set(Gun.LAST_USE, PersistentDataType.LONG, (Object)currentTime);
                    stack.setItemMeta(meta);
                    gun.shoot(p, stack);
                }
            }, 1L);
        }
        this.scheduleRepeatingSync(() -> {
            for (Player p : this.getServer().getOnlinePlayers()) {
                PlayerInventory inv = p.getInventory();
                ItemStack head = inv.getHelmet();
                Util.ifPowerSuit(head, suit -> SlimefunWarfare.process(head, PowerSuit.getModules(head), suit, p));
                ItemStack chest = inv.getChestplate();
                Util.ifPowerSuit(chest, suit -> SlimefunWarfare.process(chest, PowerSuit.getModules(chest), suit, p));
                ItemStack legs = inv.getLeggings();
                Util.ifPowerSuit(legs, suit -> SlimefunWarfare.process(legs, PowerSuit.getModules(legs), suit, p));
                ItemStack boots = inv.getBoots();
                Util.ifPowerSuit(boots, suit -> SlimefunWarfare.process(boots, PowerSuit.getModules(boots), suit, p), () -> {
                    UUID uuid = p.getUniqueId();
                    if (flying.contains(uuid)) {
                        flying.remove(uuid);
                        p.setAllowFlight(false);
                    }
                });
            }
        }, 20L);
        if (this.getConfig().getBoolean("suits.flight-particles", true)) {
            this.scheduleRepeatingSync(() -> {
                for (UUID uuid : flying) {
                    Player p = this.getServer().getPlayer(uuid);
                    if (p == null) {
                        flying.remove(uuid);
                        return;
                    }
                    if (!p.isFlying()) continue;
                    p.getWorld().spawnParticle(Particle.SOUL_FIRE_FLAME, p.getLocation().subtract(0.0, 1.0, 0.0), 20, 0.5, 0.5, 0.5);
                }
            }, 4L);
        }
    }

    @Override
    protected void onAddonDisable() {
        instance = null;
    }

    @Override
    @Nullable
    protected Metrics setupMetrics() {
        return new Metrics(this, 9227);
    }

    @Override
    @Nonnull
    protected String getGithubPath() {
        return "Seggan/SlimefunWarfare/master";
    }

    @EventHandler
    public void onPlayerJoin(@Nonnull PlayerJoinEvent e) {
        Player p = e.getPlayer();
        ItemStack boots = p.getInventory().getBoots();
        if (p.getAllowFlight() && SlimefunItem.getByItem((ItemStack)boots) instanceof PowerSuit && Sets.newHashSet((Object[])PowerSuit.getModules(boots)).contains((Object)Module.MINI_JETS)) {
            flying.add(p.getUniqueId());
        }
    }

    @EventHandler
    public void onPlayerLeave(@Nonnull PlayerQuitEvent e) {
        flying.remove(e.getPlayer().getUniqueId());
    }

    private static void process(ItemStack stack, Module[] modules, PowerSuit suit, Player p) {
        UUID uuid = p.getUniqueId();
        block4: for (Module module : modules) {
            PotionEffect effect = module.getEffect();
            if (effect != null && suit.getItemCharge(stack) >= (float)module.getPower()) {
                p.addPotionEffect(effect);
                suit.removeItemCharge(stack, module.getPower());
            }
            switch (module) {
                case MINI_JETS: {
                    if (!p.getAllowFlight()) {
                        p.setAllowFlight(true);
                        flying.add(uuid);
                    }
                    if (!p.isFlying()) continue block4;
                    if (suit.getItemCharge(stack) < (float)module.getPower()) {
                        p.setAllowFlight(false);
                        flying.remove(uuid);
                        continue block4;
                    }
                    suit.removeItemCharge(stack, module.getPower());
                    continue block4;
                }
                case AUXILIARY_GENERATOR: {
                    suit.addItemCharge(stack, module.getPower());
                }
            }
        }
        if (suit.getType() == ArmorPiece.FEET && flying.contains(p.getUniqueId()) && !Sets.newHashSet((Object[])modules).contains((Object)Module.MINI_JETS)) {
            p.setAllowFlight(false);
            flying.remove(uuid);
        }
        suit.addItemCharge(stack, 5.0f);
    }

    private static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }

    public static SlimefunWarfare inst() {
        return instance;
    }
}

