/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.infinitylib.slimefun.presets;

import io.github.seggan.slimefunwarfare.infinitylib.slimefun.utils.TickerUtils;
import java.text.DecimalFormat;
import javax.annotation.Nonnull;

public final class LorePreset {
    private static final DecimalFormat FORMAT = new DecimalFormat("###,###,###,###,###,###.#");

    @Nonnull
    public static String energyPerSecond(int energy) {
        return "&8\u21e8 &e\u26a1 &7" + LorePreset.format((double)energy * TickerUtils.TPS) + " J/s";
    }

    @Nonnull
    public static String energyBuffer(int energy) {
        return "&8\u21e8 &e\u26a1 &7" + LorePreset.format(energy) + " J Buffer";
    }

    @Nonnull
    public static String energy(int energy) {
        return "&8\u21e8 &e\u26a1 &7" + LorePreset.format(energy) + " J ";
    }

    @Nonnull
    public static String speed(int speed) {
        return "&8\u21e8 &b\u26a1 &7Speed: &b" + speed + 'x';
    }

    @Nonnull
    public static String format(double number) {
        return FORMAT.format(number);
    }

    private LorePreset() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

