/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.infinitylib.configuration;

import io.github.seggan.slimefunwarfare.infinitylib.AbstractAddon;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.apache.commons.codec.Charsets;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public final class AddonConfig
extends YamlConfiguration {
    private final Map<String, String> comments = new HashMap<String, String>();
    private final File file;

    public AddonConfig(AbstractAddon addon, String path) {
        this.file = new File(addon.getDataFolder(), path);
        YamlConfiguration defaults = new YamlConfiguration();
        try {
            defaults.loadFromString(this.loadDefaults(addon, path));
        }
        catch (InvalidConfigurationException e) {
            addon.log(Level.SEVERE, "There was an error loading the default config of '" + path + "', report this to the developers!");
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (path.equals("config.yml")) {
            defaults.set(addon.getAutoUpdatePath(), (Object)true);
            this.addComment(addon.getAutoUpdatePath(), "\n# This must be enabled to receive support!\n");
        }
        this.setDefaults((Configuration)defaults);
        if (this.file.exists()) {
            try {
                this.load(this.file);
            }
            catch (InvalidConfigurationException e) {
                addon.log(Level.SEVERE, "There was an error loading the config '" + path + "', resetting to default!");
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        for (String key : this.getKeys(true)) {
            if (defaults.contains(key)) continue;
            this.set(key, null);
        }
        this.save();
    }

    public void addComment(String path, String comment) {
        this.comments.putIfAbsent(path, comment);
    }

    public int getInt(String path, int min, int max) {
        int val = this.getInt(path);
        if (val < min || val > max) {
            val = this.getDefaults().getInt(path);
            this.set(path, val);
        }
        return val;
    }

    public double getDouble(String path, double min, double max) {
        double val = this.getDouble(path);
        if (val < min || val > max) {
            val = this.getDefaults().getDouble(path);
            this.set(path, val);
        }
        return val;
    }

    public void save() {
        try {
            this.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Nonnull
    public Configuration getDefaults() {
        return Objects.requireNonNull(super.getDefaults());
    }

    @Nonnull
    protected String buildHeader() {
        return "";
    }

    @Nonnull
    public String saveToString() {
        this.options().copyDefaults(true).copyHeader(false);
        String string = super.saveToString();
        StringBuilder save = new StringBuilder();
        String[] lines = string.split("\n");
        StringBuilder pathBuilder = new StringBuilder();
        ArrayList<Integer> dotIndexes = new ArrayList<Integer>(2);
        for (String line : lines) {
            String comment = this.comments.get(AddonConfig.appendPath(pathBuilder, dotIndexes, line));
            if (comment == null) {
                save.append('\n').append(line).append('\n');
                continue;
            }
            save.append(comment).append(line).append('\n');
        }
        return save.toString();
    }

    private String loadDefaults(AbstractAddon addon, String filePath) throws IOException {
        String line;
        BufferedReader input = new BufferedReader(new InputStreamReader(Objects.requireNonNull(addon.getResource(filePath), () -> "No default config for " + filePath + "!"), Charsets.UTF_8));
        StringBuilder yamlBuilder = new StringBuilder();
        StringBuilder commentBuilder = new StringBuilder();
        StringBuilder pathBuilder = new StringBuilder();
        ArrayList<Integer> dotIndexes = new ArrayList<Integer>(2);
        while ((line = input.readLine()) != null) {
            yamlBuilder.append(line).append('\n');
            if (StringUtils.isBlank((String)line)) {
                commentBuilder.append(line).append('\n');
                continue;
            }
            if (line.contains("#")) {
                if (commentBuilder.length() == 0) {
                    commentBuilder.append('\n');
                }
                commentBuilder.append(line).append('\n');
                continue;
            }
            if (commentBuilder.length() == 0) {
                AddonConfig.appendPath(pathBuilder, dotIndexes, line);
                continue;
            }
            this.comments.put(AddonConfig.appendPath(pathBuilder, dotIndexes, line), commentBuilder.toString());
            commentBuilder = new StringBuilder();
        }
        input.close();
        return yamlBuilder.toString();
    }

    private static String appendPath(StringBuilder path, List<Integer> dotIndexes, String line) {
        int indent = 0;
        for (int i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
            ++indent;
        }
        String key = line.substring(indent, line.lastIndexOf(58));
        if ((indent >>= 2) == 0) {
            path = new StringBuilder(key);
            if (dotIndexes.size() != 0) {
                dotIndexes.clear();
            }
        } else if (indent <= dotIndexes.size()) {
            path.replace(dotIndexes.get(indent - 1), path.length(), key);
        } else {
            path.append('.');
            dotIndexes.add(path.length());
            path.append(key);
        }
        return path.toString();
    }
}

