/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.infinitylib;

import io.github.seggan.slimefunwarfare.infinitylib.bstats.bukkit.Metrics;
import io.github.seggan.slimefunwarfare.infinitylib.bstats.charts.SimplePie;
import io.github.seggan.slimefunwarfare.infinitylib.commands.AbstractCommand;
import io.github.seggan.slimefunwarfare.infinitylib.commands.CommandManager;
import io.github.seggan.slimefunwarfare.infinitylib.configuration.AddonConfig;
import io.github.seggan.slimefunwarfare.infinitylib.slimefun.utils.TickerUtils;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.GitHubBuildsUpdater;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;

public abstract class AbstractAddon
extends JavaPlugin
implements SlimefunAddon {
    private final String bugTrackerURL = "https://github.com/" + this.getGithubPath().substring(0, this.getGithubPath().lastIndexOf(47)) + "/issues";
    private int globalTick;
    private AddonConfig config;

    public AbstractAddon() {
    }

    @ParametersAreNonnullByDefault
    public AbstractAddon(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file) {
        super(loader, description, dataFolder, file);
    }

    @OverridingMethodsMustInvokeSuper
    public void onEnable() {
        Metrics metrics;
        this.config = new AddonConfig(this, "config.yml");
        boolean autoUpdate = this.config.getBoolean(this.getAutoUpdatePath());
        if (autoUpdate) {
            if (this.getDescription().getVersion().startsWith("DEV - ")) {
                new GitHubBuildsUpdater((Plugin)this, this.getFile(), this.getGithubPath()).start();
            }
        } else {
            this.runSync(() -> this.log("#######################################", "Auto Updates have been disabled for " + this.getName(), "You will receive no support for bugs", "Until you update to the latest version!", "#######################################"));
        }
        if ((metrics = this.setupMetrics()) != null) {
            String autoUpdates = String.valueOf(autoUpdate);
            metrics.addCustomChart(new SimplePie("auto_updates", () -> autoUpdates));
        }
        this.scheduleRepeatingSync(() -> ++this.globalTick, TickerUtils.TICKS);
        CommandManager.register(this, this.getName(), this.getSubCommands());
    }

    @OverridingMethodsMustInvokeSuper
    public void onLoad() {
        Bukkit.spigot().getConfig().set("world-settings.default.verbose", (Object)false);
    }

    @Nullable
    protected abstract Metrics setupMetrics();

    @Nonnull
    protected abstract String getGithubPath();

    @Nonnull
    protected abstract List<AbstractCommand> getSubCommands();

    @Nonnull
    public String getAutoUpdatePath() {
        return "auto-update";
    }

    @Nonnull
    public final JavaPlugin getJavaPlugin() {
        return this;
    }

    @Nonnull
    public final String getBugTrackerURL() {
        return this.bugTrackerURL;
    }

    public final NamespacedKey getKey(String s) {
        return new NamespacedKey((Plugin)this, s);
    }

    public final void log(String ... messages) {
        this.log(Level.INFO, messages);
    }

    public final void log(Level level, String ... messages) {
        for (String msg : messages) {
            this.getLogger().log(level, msg);
        }
    }

    public final void registerListener(Listener ... listeners) {
        for (Listener listener : listeners) {
            Bukkit.getPluginManager().registerEvents(listener, (Plugin)this);
        }
    }

    public final void runSync(Runnable runnable) {
        Bukkit.getScheduler().runTask((Plugin)this, runnable);
    }

    public final void runSync(Runnable runnable, long delay) {
        Bukkit.getScheduler().runTaskLater((Plugin)this, runnable, delay);
    }

    public final void scheduleRepeatingSync(Runnable runnable, long interval) {
        Bukkit.getScheduler().runTaskTimer((Plugin)this, runnable, 0L, interval);
    }

    public final void scheduleRepeatingSync(Runnable runnable, long delay, long interval) {
        Bukkit.getScheduler().runTaskTimer((Plugin)this, runnable, delay, interval);
    }

    public final void runAsync(Runnable runnable) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, runnable);
    }

    public final void runAsync(Runnable runnable, long delay) {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, runnable, delay);
    }

    public final void scheduleRepeatingAsync(Runnable runnable, long interval) {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, runnable, 0L, interval);
    }

    public final void scheduleRepeatingAsync(Runnable runnable, long delay, long interval) {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, runnable, delay, interval);
    }

    public int getGlobalTick() {
        return this.globalTick;
    }

    public AddonConfig getConfig() {
        return this.config;
    }
}

