/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.listeners;

import io.github.seggan.slimefunwarfare.items.Dummy;
import io.github.seggan.slimefunwarfare.items.EnergyBlade;
import io.github.seggan.slimefunwarfare.lists.items.Melee;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.data.PersistentDataAPI;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;

public class HitListener
implements Listener {
    @EventHandler(priority=EventPriority.NORMAL)
    public void onEnergyBladeHit(EntityDamageByEntityEvent e) {
        Entity entity = e.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        ItemStack item = ((Player)entity).getInventory().getItemInMainHand();
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)item);
        if (slimefunItem instanceof EnergyBlade) {
            EnergyBlade blade = (EnergyBlade)slimefunItem;
            float charge = blade.getItemCharge(item);
            if (charge < 5.0f) {
                e.setCancelled(true);
                e.getEntity().setFireTicks(0);
            } else {
                blade.removeItemCharge(item, 5.0f);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDummyHit(EntityDamageByEntityEvent e) {
        if (!(e.getDamager() instanceof Player)) {
            return;
        }
        Entity entity = e.getEntity();
        if (PersistentDataAPI.getString((PersistentDataHolder)entity, (NamespacedKey)Dummy.KEY) != null) {
            e.setCancelled(true);
            Player p = (Player)e.getDamager();
            p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)ChatColors.color((String)String.format("&cYou have dealt %d half-hearts of damage", Math.round(e.getFinalDamage())))));
        }
    }

    @EventHandler
    public void onDummyDestroy(PlayerInteractEntityEvent e) {
        Entity entity = e.getRightClicked();
        if (PersistentDataAPI.getString((PersistentDataHolder)entity, (NamespacedKey)Dummy.KEY) != null) {
            entity.remove();
            entity.getWorld().dropItemNaturally(entity.getLocation(), Melee.DUMMY.clone());
        }
    }
}

