/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.infinitylib.commands;

import io.github.seggan.slimefunwarfare.infinitylib.commands.AbstractCommand;
import io.github.seggan.slimefunwarfare.infinitylib.core.PluginUtils;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

public final class CommandManager
implements CommandExecutor,
TabCompleter {
    private final Map<String, AbstractCommand> commands = new HashMap<String, AbstractCommand>();
    private final String aliases;
    private final String command;

    public static CommandManager setup(String command, String aliases, AbstractCommand ... commands) {
        CommandManager manager = new CommandManager(Objects.requireNonNull(PluginUtils.getPlugin().getCommand(command)), aliases);
        for (AbstractCommand command1 : commands) {
            manager.addCommand(command1);
        }
        return manager;
    }

    private CommandManager(PluginCommand command, String aliases) {
        this.aliases = ChatColors.color((String)("&6Aliases: &e" + aliases));
        this.command = command.getName();
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)this);
        this.addCommand(new Info());
        this.addCommand(new Help());
    }

    private void addCommand(AbstractCommand command) {
        this.commands.put(command.name, command);
    }

    public boolean onCommand(@Nonnull CommandSender sender, @Nonnull Command command, @Nonnull String label, @Nonnull String[] args) {
        AbstractCommand command1;
        if (args.length > 0 && (command1 = this.commands.get(args[0])) != null && command1.hasPerm(sender)) {
            command1.onExecute(sender, args);
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(@Nonnull CommandSender sender, @Nonnull Command command, @Nonnull String alias, String[] args) {
        AbstractCommand command1;
        if (args.length == 1) {
            ArrayList<String> strings = new ArrayList<String>();
            for (AbstractCommand command12 : this.commands.values()) {
                if (!command12.hasPerm(sender)) continue;
                strings.add(command12.name);
            }
            return CommandManager.createReturnList(strings, args[0]);
        }
        if (args.length > 1 && (command1 = this.commands.get(args[0])) != null && command1.hasPerm(sender)) {
            ArrayList<String> strings = new ArrayList<String>();
            command1.onTab(sender, args, strings);
            return CommandManager.createReturnList(strings, args[args.length - 1]);
        }
        return Collections.emptyList();
    }

    @Nonnull
    private static List<String> createReturnList(@Nonnull List<String> strings, @Nonnull String string) {
        String input = string.toLowerCase(Locale.ROOT);
        LinkedList<String> returnList = new LinkedList<String>();
        for (String item : strings) {
            if (item.toLowerCase(Locale.ROOT).contains(input)) {
                returnList.add(item);
                if (returnList.size() < 64) continue;
                break;
            }
            if (!item.equalsIgnoreCase(input)) continue;
            return Collections.emptyList();
        }
        return returnList;
    }

    private static final class Info
    extends AbstractCommand {
        private static final String[] INFO = new String[]{"", ChatColors.color((String)("&aSlimefun Version: " + Objects.requireNonNull(SlimefunPlugin.instance()).getPluginVersion())), ChatColors.color((String)"&bSlimefun Discord: &7Discord.gg/slimefun"), ChatColors.color((String)("&aAddon Version: " + PluginUtils.getAddon().getPluginVersion())), ChatColors.color((String)"&bAddon Community: &7Discord.gg/SqD3gg5SAU"), ChatColors.color((String)("&aGithub: &7" + PluginUtils.getAddon().getBugTrackerURL())), ""};

        private Info() {
            super("info", "Gives version information", false);
        }

        @Override
        public void onExecute(@Nonnull CommandSender sender, @Nonnull String[] args) {
            sender.sendMessage(INFO);
        }

        @Override
        protected void onTab(@Nonnull CommandSender sender, @Nonnull String[] args, @Nonnull List<String> tabs) {
        }
    }

    private final class Help
    extends AbstractCommand
    implements Listener {
        private Help() {
            super("help", "Displays this", false);
            PluginUtils.registerListener(this);
        }

        @Override
        public void onExecute(@Nonnull CommandSender sender, @Nonnull String[] args) {
            sender.sendMessage("");
            sender.sendMessage(ChatColors.color((String)("&7----------&b&l " + PluginUtils.getPlugin().getName() + " &7----------")));
            sender.sendMessage("");
            for (AbstractCommand command : CommandManager.this.commands.values()) {
                if (!command.hasPerm(sender)) continue;
                sender.sendMessage(ChatColors.color((String)("&6/" + CommandManager.this.command + " " + command.name + " &e- " + command.description)));
            }
            sender.sendMessage("");
            sender.sendMessage(CommandManager.this.aliases);
            sender.sendMessage("");
        }

        @Override
        protected void onTab(@Nonnull CommandSender sender, @Nonnull String[] args, @Nonnull List<String> tabs) {
        }

        @EventHandler
        public void onCommand(PlayerCommandPreprocessEvent e) {
            if (e.getMessage().equalsIgnoreCase("/help " + CommandManager.this.command)) {
                this.onExecute((CommandSender)e.getPlayer(), new String[0]);
                e.setCancelled(true);
            }
        }
    }
}

