/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.items.guns;

import io.github.seggan.slimefunwarfare.SlimefunWarfare;
import io.github.seggan.slimefunwarfare.Util;
import io.github.seggan.slimefunwarfare.infinitylib.core.ConfigUtils;
import io.github.seggan.slimefunwarfare.infinitylib.core.PluginUtils;
import io.github.seggan.slimefunwarfare.items.Bullet;
import io.github.seggan.slimefunwarfare.lists.Categories;
import io.github.thebusybiscuit.slimefun4.core.attributes.DamageableItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Gun
extends SlimefunItem
implements DamageableItem {
    public static final NamespacedKey LAST_USE = PluginUtils.getKey("last_use");
    private final int range;
    private final int minRange;
    private final int damageDealt;
    private final int cooldown;

    public Gun(SlimefunItemStack item, ItemStack[] recipe, int range, int damage, double cooldown) {
        super(Categories.GUNS, item, RecipeType.ENHANCED_CRAFTING_TABLE, recipe);
        this.range = range;
        this.minRange = 0;
        this.damageDealt = damage;
        this.cooldown = (int)(cooldown * 1000.0);
        this.addItemHandler(new ItemHandler[]{this.getItemHandler()});
    }

    public Gun(SlimefunItemStack item, ItemStack[] recipe, int range, int minRange, int damage, double cooldown) {
        super(Categories.GUNS, item, RecipeType.ENHANCED_CRAFTING_TABLE, recipe);
        this.range = range;
        this.minRange = ConfigUtils.getBoolean("guns.min-range-on", true) ? minRange : 0;
        this.damageDealt = damage;
        this.cooldown = (int)(cooldown * 1000.0);
        this.addItemHandler(new ItemHandler[]{this.getItemHandler()});
    }

    public ItemUseHandler getItemHandler() {
        return e -> {
            e.cancel();
            Player p = e.getPlayer();
            ItemStack gun = p.getInventory().getItemInMainHand();
            if (!(SlimefunItem.getByItem((ItemStack)gun) instanceof Gun)) {
                return;
            }
            ItemMeta meta = gun.getItemMeta();
            PersistentDataContainer container = meta.getPersistentDataContainer();
            long lastUse = (Long)container.getOrDefault(LAST_USE, PersistentDataType.LONG, (Object)0L);
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastUse < (long)this.cooldown) {
                p.sendMessage(ChatColor.RED + "The gun is still reloading!");
                return;
            }
            container.set(LAST_USE, PersistentDataType.LONG, (Object)currentTime);
            gun.setItemMeta(meta);
            this.shoot(p, gun);
        };
    }

    public void shoot(Player p, ItemStack gun) {
        boolean isFire;
        double multiplier;
        PlayerInventory inv = p.getInventory();
        ItemStack stack = inv.getItemInOffHand();
        SlimefunItem item = SlimefunItem.getByItem((ItemStack)stack);
        if (item instanceof Bullet) {
            Bullet bullet = (Bullet)item;
            multiplier = bullet.getMultiplier();
            isFire = bullet.isFire();
            stack.setAmount(stack.getAmount() - 1);
            inv.setItemInOffHand(stack);
        } else if (ConfigUtils.getBoolean("guns.use-bullets-from-inv", true)) {
            for (int i = 0; i < inv.getSize(); ++i) {
                stack = inv.getItem(i);
                item = SlimefunItem.getByItem((ItemStack)stack);
                if (!(item instanceof Bullet)) continue;
                Bullet bullet = (Bullet)item;
                multiplier = bullet.getMultiplier();
                isFire = bullet.isFire();
                ItemUtils.consumeItem((ItemStack)stack, (boolean)true);
                break;
            }
        } else {
            p.sendMessage(ChatColor.RED + "You have run out of bullets!");
            return;
        }
        Vector v = p.getEyeLocation().subtract(0.0, 1.0, 0.0).getDirection().multiply(20);
        LlamaSpit bullet = (LlamaSpit)p.launchProjectile(LlamaSpit.class);
        bullet.setMetadata("isGunBullet", (MetadataValue)new FixedMetadataValue((Plugin)SlimefunWarfare.getInstance(), (Object)true));
        bullet.setMetadata("damage", (MetadataValue)new FixedMetadataValue((Plugin)SlimefunWarfare.getInstance(), (Object)((double)this.damageDealt * multiplier)));
        bullet.setMetadata("isFire", (MetadataValue)new FixedMetadataValue((Plugin)SlimefunWarfare.getInstance(), (Object)isFire));
        bullet.setMetadata("locInfo", (MetadataValue)new FixedMetadataValue((Plugin)SlimefunWarfare.getInstance(), (Object)Util.serializeLocation(p.getEyeLocation())));
        bullet.setMetadata("rangeInfo", (MetadataValue)new FixedMetadataValue((Plugin)SlimefunWarfare.getInstance(), (Object)(this.range + ":" + this.minRange)));
        bullet.setVelocity(v);
    }

    public boolean isDamageable() {
        return true;
    }

    public int getRange() {
        return this.range;
    }

    public int getMinRange() {
        return this.minRange;
    }

    public int getDamageDealt() {
        return this.damageDealt;
    }

    public int getCooldown() {
        return this.cooldown;
    }
}

