/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare;

import io.github.seggan.slimefunwarfare.Setup;
import io.github.seggan.slimefunwarfare.infinitylib.core.ConfigUtils;
import io.github.seggan.slimefunwarfare.infinitylib.core.PluginUtils;
import io.github.seggan.slimefunwarfare.items.guns.Gun;
import io.github.seggan.slimefunwarfare.listeners.BetterExplosiveListener;
import io.github.seggan.slimefunwarfare.listeners.BulletListener;
import io.github.seggan.slimefunwarfare.listeners.ConcreteListener;
import io.github.seggan.slimefunwarfare.listeners.GrenadeListener;
import io.github.seggan.slimefunwarfare.listeners.HitListener;
import io.github.seggan.slimefunwarfare.listeners.PyroListener;
import io.github.seggan.slimefunwarfare.listeners.SpaceListener;
import io.github.seggan.slimefunwarfare.spacegenerators.SpaceGenerator;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.entity.Player;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SlimefunWarfare
extends JavaPlugin
implements SlimefunAddon {
    private static SlimefunWarfare instance = null;

    public void onEnable() {
        instance = this;
        PluginUtils.setup("SlimefunWarfare", this, "Seggan/SlimefunWarfare/master", this.getFile());
        PluginUtils.setupMetrics(9227);
        PluginUtils.registerListener(new BulletListener());
        PluginUtils.registerListener(new PyroListener());
        PluginUtils.registerListener(new GrenadeListener());
        PluginUtils.registerListener(new ConcreteListener());
        PluginUtils.registerListener(new BetterExplosiveListener());
        PluginUtils.registerListener(new SpaceListener());
        PluginUtils.registerListener(new HitListener());
        Setup.setupItems(this);
        Setup.setupMelee(this);
        Setup.setupBullets(this);
        Setup.setupGuns(this);
        Setup.setupExplosives(this);
        Setup.setupSpace(this);
        for (World world : Bukkit.getWorlds()) {
            World space;
            String name = world.getName();
            if (name.endsWith("_nether") || name.endsWith("_the_end") || (space = Bukkit.getWorld((String)(name + "_space"))) != null || !SlimefunPlugin.getWorldSettingsService().isWorldEnabled(world)) continue;
            WorldCreator creator = new WorldCreator(name + "_space").seed(world.getSeed()).generator((ChunkGenerator)new SpaceGenerator());
            space = creator.createWorld();
            space.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
            space.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)false);
            space.setTime(18000L);
        }
        if (ConfigUtils.getBoolean("guns.autoshoot", true)) {
            Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
                for (Player p : this.getServer().getOnlinePlayers()) {
                    ItemStack stack;
                    SlimefunItem item;
                    if (!p.isSneaking() || p.isFlying() || !((item = SlimefunItem.getByItem((ItemStack)(stack = p.getInventory().getItemInMainHand()))) instanceof Gun)) continue;
                    Gun gun = (Gun)item;
                    ItemMeta meta = stack.getItemMeta();
                    PersistentDataContainer container = meta.getPersistentDataContainer();
                    long lastUse = (Long)container.getOrDefault(Gun.LAST_USE, PersistentDataType.LONG, (Object)0L);
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - lastUse < (long)gun.getCooldown()) continue;
                    container.set(Gun.LAST_USE, PersistentDataType.LONG, (Object)currentTime);
                    stack.setItemMeta(meta);
                    gun.shoot(p, stack);
                }
            }, 0L, 1L);
        }
    }

    public void onDisable() {
        this.getLogger().info("Slimefun Warfare disabled.");
    }

    public JavaPlugin getJavaPlugin() {
        return this;
    }

    public String getBugTrackerURL() {
        return null;
    }

    public static SlimefunWarfare getInstance() {
        return instance;
    }
}

