/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.items;

import io.github.seggan.slimefunwarfare.SlimefunWarfare;
import io.github.seggan.slimefunwarfare.Util;
import io.github.seggan.slimefunwarfare.items.Bullet;
import io.github.seggan.slimefunwarfare.lists.Items;
import io.github.thebusybiscuit.slimefun4.core.attributes.DamageableItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.ChatColor;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Gun
extends SlimefunItem
implements DamageableItem {
    private final HashMap<UUID, Long> LAST_USES = new HashMap();
    private final int range;
    private final int minRange;
    private final int damageDealt;
    private final int cooldown;

    public Gun(SlimefunItemStack item, ItemStack[] recipe, int range, int damage, double cooldown) {
        super(Items.sfwarfareGunsCategory, item, RecipeType.ENHANCED_CRAFTING_TABLE, recipe);
        this.range = range;
        this.minRange = 0;
        this.damageDealt = damage;
        this.cooldown = (int)(cooldown * 1000.0);
        this.addItemHandler(new ItemHandler[]{this.getItemHandler()});
    }

    public Gun(SlimefunItemStack item, ItemStack[] recipe, int range, int minRange, int damage, double cooldown) {
        super(Items.sfwarfareGunsCategory, item, RecipeType.ENHANCED_CRAFTING_TABLE, recipe);
        this.range = range;
        this.minRange = minRange;
        this.damageDealt = damage;
        this.cooldown = (int)(cooldown * 1000.0);
        this.addItemHandler(new ItemHandler[]{this.getItemHandler()});
    }

    public ItemUseHandler getItemHandler() {
        return e -> {
            e.cancel();
            this.shoot(e.getPlayer());
        };
    }

    public void shoot(Player p) {
        boolean isFire;
        double multiplier;
        block5: {
            PlayerInventory inv = p.getInventory();
            ItemStack gun = inv.getItemInMainHand();
            if (!(SlimefunItem.getByItem((ItemStack)gun) instanceof Gun)) {
                return;
            }
            Long lastUse = this.LAST_USES.get(p.getUniqueId());
            long currentTime = System.currentTimeMillis();
            if (lastUse != null && currentTime - lastUse < (long)this.cooldown) {
                p.sendMessage(ChatColor.RED + "The gun is still reloading!");
                return;
            }
            this.LAST_USES.put(p.getUniqueId(), currentTime);
            ItemStack stack = inv.getItemInOffHand();
            SlimefunItem item = SlimefunItem.getByItem((ItemStack)stack);
            if (item instanceof Bullet) {
                multiplier = ((Bullet)item).getMultiplier();
                isFire = item.getID().equals("DU_BULLET");
                stack.setAmount(stack.getAmount() - 1);
                inv.setItemInOffHand(stack);
            } else {
                Object[] contents = inv.getContents();
                Iterator iter = Arrays.stream(contents).iterator();
                while (iter.hasNext()) {
                    stack = (ItemStack)iter.next();
                    item = SlimefunItem.getByItem((ItemStack)stack);
                    if (!(item instanceof Bullet)) continue;
                    multiplier = ((Bullet)item).getMultiplier();
                    isFire = item.getID().equals("DU_BULLET");
                    stack.setAmount(stack.getAmount() - 1);
                    contents[ArrayUtils.indexOf((Object[])contents, (Object)stack)] = stack;
                    inv.setContents((ItemStack[])contents);
                    break block5;
                }
                p.sendMessage(ChatColor.RED + "You have run out of bullets!");
                return;
            }
        }
        Vector v = p.getEyeLocation().subtract(0.0, 1.0, 0.0).getDirection().multiply(20);
        LlamaSpit bullet = (LlamaSpit)p.launchProjectile(LlamaSpit.class);
        bullet.setMetadata("isGunBullet", (MetadataValue)new FixedMetadataValue((Plugin)SlimefunWarfare.getInstance(), (Object)true));
        bullet.setMetadata("damage", (MetadataValue)new FixedMetadataValue((Plugin)SlimefunWarfare.getInstance(), (Object)((double)this.damageDealt * multiplier)));
        bullet.setMetadata("isFire", (MetadataValue)new FixedMetadataValue((Plugin)SlimefunWarfare.getInstance(), (Object)isFire));
        bullet.setMetadata("locInfo", (MetadataValue)new FixedMetadataValue((Plugin)SlimefunWarfare.getInstance(), (Object)Util.serializeLocation(p.getEyeLocation())));
        bullet.setMetadata("rangeInfo", (MetadataValue)new FixedMetadataValue((Plugin)SlimefunWarfare.getInstance(), (Object)(this.range + ":" + this.minRange)));
        bullet.setVelocity(v);
    }

    public boolean isDamageable() {
        return true;
    }

    public HashMap<UUID, Long> getLAST_USES() {
        return this.LAST_USES;
    }

    public int getCooldown() {
        return this.cooldown;
    }
}

