/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.slimefunwarfare.items.guns;

import io.github.seggan.slimefunwarfare.SlimefunWarfare;
import io.github.seggan.slimefunwarfare.Util;
import io.github.seggan.slimefunwarfare.items.Bullet;
import io.github.seggan.slimefunwarfare.lists.Categories;
import io.github.thebusybiscuit.slimefun4.core.attributes.DamageableItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import java.util.HashMap;
import java.util.UUID;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import org.bukkit.ChatColor;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Gun
extends SlimefunItem
implements DamageableItem {
    private final HashMap<UUID, Long> LAST_USES = new HashMap();
    private final int range;
    private final int minRange;
    private final int damageDealt;
    private final int cooldown;

    public Gun(SlimefunItemStack item, ItemStack[] recipe, int range, int damage, double cooldown) {
        super(Categories.GUNS, item, RecipeType.ENHANCED_CRAFTING_TABLE, recipe);
        this.range = range;
        this.minRange = 0;
        this.damageDealt = damage;
        this.cooldown = (int)(cooldown * 1000.0);
        this.addItemHandler(new ItemHandler[]{this.getItemHandler()});
    }

    public Gun(SlimefunItemStack item, ItemStack[] recipe, int range, int minRange, int damage, double cooldown) {
        super(Categories.GUNS, item, RecipeType.ENHANCED_CRAFTING_TABLE, recipe);
        this.range = range;
        this.minRange = SlimefunWarfare.getConfigSettings().isMinRangeOn() ? minRange : 0;
        this.damageDealt = damage;
        this.cooldown = (int)(cooldown * 1000.0);
        this.addItemHandler(new ItemHandler[]{this.getItemHandler()});
    }

    public ItemUseHandler getItemHandler() {
        return e -> {
            e.cancel();
            Player p = e.getPlayer();
            this.shoot(p);
        };
    }

    public void shoot(Player p) {
        boolean isFire;
        double multiplier;
        PlayerInventory inv = p.getInventory();
        ItemStack gun = inv.getItemInMainHand();
        if (!(SlimefunItem.getByItem((ItemStack)gun) instanceof Gun)) {
            return;
        }
        Long lastUse = this.LAST_USES.get(p.getUniqueId());
        long currentTime = System.currentTimeMillis();
        if (lastUse != null && currentTime - lastUse < (long)this.cooldown) {
            p.sendMessage(ChatColor.RED + "The gun is still reloading!");
            return;
        }
        this.LAST_USES.put(p.getUniqueId(), currentTime);
        ItemStack stack = inv.getItemInOffHand();
        SlimefunItem item = SlimefunItem.getByItem((ItemStack)stack);
        if (item instanceof Bullet) {
            Bullet bullet = (Bullet)item;
            multiplier = bullet.getMultiplier();
            isFire = bullet.isFire();
            stack.setAmount(stack.getAmount() - 1);
            inv.setItemInOffHand(stack);
        } else if (SlimefunWarfare.getConfigSettings().isUseBulletsFromInv()) {
            for (int i = 0; i < inv.getSize(); ++i) {
                stack = inv.getItem(i);
                item = SlimefunItem.getByItem((ItemStack)stack);
                if (!(item instanceof Bullet)) continue;
                Bullet bullet = (Bullet)item;
                multiplier = bullet.getMultiplier();
                isFire = bullet.isFire();
                ItemUtils.consumeItem((ItemStack)stack, (boolean)false);
                break;
            }
        } else {
            p.sendMessage(ChatColor.RED + "You have run out of bullets!");
            return;
        }
        Vector v = p.getEyeLocation().subtract(0.0, 1.0, 0.0).getDirection().multiply(20);
        LlamaSpit bullet = (LlamaSpit)p.launchProjectile(LlamaSpit.class);
        bullet.setMetadata("isGunBullet", (MetadataValue)new FixedMetadataValue((Plugin)SlimefunWarfare.getInstance(), (Object)true));
        bullet.setMetadata("damage", (MetadataValue)new FixedMetadataValue((Plugin)SlimefunWarfare.getInstance(), (Object)((double)this.damageDealt * multiplier)));
        bullet.setMetadata("isFire", (MetadataValue)new FixedMetadataValue((Plugin)SlimefunWarfare.getInstance(), (Object)isFire));
        bullet.setMetadata("locInfo", (MetadataValue)new FixedMetadataValue((Plugin)SlimefunWarfare.getInstance(), (Object)Util.serializeLocation(p.getEyeLocation())));
        bullet.setMetadata("rangeInfo", (MetadataValue)new FixedMetadataValue((Plugin)SlimefunWarfare.getInstance(), (Object)(this.range + ":" + this.minRange)));
        bullet.setVelocity(v);
    }

    public boolean isDamageable() {
        return true;
    }

    public HashMap<UUID, Long> getLAST_USES() {
        return this.LAST_USES;
    }

    public int getRange() {
        return this.range;
    }

    public int getMinRange() {
        return this.minRange;
    }

    public int getDamageDealt() {
        return this.damageDealt;
    }

    public int getCooldown() {
        return this.cooldown;
    }
}

