/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.core.services;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.clip.placeholderapi.PlaceholderAPI;
import net.guizhanss.slimefuntranslation.SlimefunTranslation;
import net.guizhanss.slimefuntranslation.core.services.PacketListenerService;
import net.guizhanss.slimefuntranslation.core.users.User;
import net.guizhanss.slimefuntranslation.integrations.placeholders.SlimefunLoreExpansion;
import org.bukkit.entity.Player;

public final class IntegrationService {
    private final SlimefunTranslation plugin;
    private final boolean protocolLibEnabled;
    private final boolean placeholderAPIEnabled;

    public IntegrationService(SlimefunTranslation plugin) {
        this.plugin = plugin;
        this.protocolLibEnabled = this.isEnabled("ProtocolLib");
        this.placeholderAPIEnabled = this.isEnabled("PlaceholderAPI");
        if (this.protocolLibEnabled) {
            SlimefunTranslation.log(Level.INFO, "ProtocolLib found, enabling packet listener...", new Object[0]);
            new PacketListenerService();
        } else {
            SlimefunTranslation.log(Level.SEVERE, "ProtocolLib not found, this plugin will not be fully functional...", new Object[0]);
        }
        if (this.placeholderAPIEnabled) {
            SlimefunTranslation.log(Level.INFO, "PlaceholderAPI found, enabling placeholders...", new Object[0]);
            new SlimefunLoreExpansion().register();
        } else {
            SlimefunTranslation.log(Level.SEVERE, "PlaceholderAPI not found, this plugin will not be fully functional...", new Object[0]);
        }
    }

    private boolean isEnabled(@Nonnull String pluginName) {
        return this.plugin.getServer().getPluginManager().isPluginEnabled(pluginName);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public String applyPlaceholders(User user, String str) {
        if (!this.placeholderAPIEnabled) {
            return str;
        }
        return PlaceholderAPI.setPlaceholders((Player)user.getPlayer(), (String)str);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public List<String> applyPlaceholders(User user, List<String> list) {
        if (!this.placeholderAPIEnabled) {
            return list;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String str : list) {
            result.add(this.applyPlaceholders(user, str));
        }
        return result;
    }

    public boolean isProtocolLibEnabled() {
        return this.protocolLibEnabled;
    }

    public boolean isPlaceholderAPIEnabled() {
        return this.placeholderAPIEnabled;
    }
}

