/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.core.commands.subcommands.translation;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.groups.FlexItemGroup;
import io.github.thebusybiscuit.slimefun4.core.services.localization.Language;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.slimefuntranslation.SlimefunTranslation;
import net.guizhanss.slimefuntranslation.core.commands.AbstractSubCommand;
import net.guizhanss.slimefuntranslation.libs.guizhanlib.minecraft.commands.AbstractCommand;
import net.guizhanss.slimefuntranslation.libs.guizhanlib.minecraft.commands.SubCommand;
import net.guizhanss.slimefuntranslation.utils.constant.Permissions;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class GenerateCommand
extends AbstractSubCommand {
    public GenerateCommand(@Nonnull AbstractCommand parent) {
        super(parent, "generate", (AbstractCommand cmd, CommandSender sender) -> GenerateCommand.getDescription("translation.generate", sender), "<addon> <language> [itemgroup]", new SubCommand[0]);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onExecute(CommandSender sender, String[] args) {
        if (!Permissions.COMMAND_TRANSLATION_GENERATE.hasPermission(sender)) {
            MESSAGE_FACTORY.sendMessage(sender, "no-permission", new Object[0]);
            return;
        }
        String addonName = args[0];
        String language = args[1];
        if (!SlimefunTranslation.getInstance().getServer().getPluginManager().isPluginEnabled(addonName)) {
            MESSAGE_FACTORY.sendMessage(sender, "commands.translation.generate.invalid-addon", addonName);
            return;
        }
        HashSet<String> exportIds = new HashSet<String>();
        if (args.length == 3) {
            ItemGroup itemGroup = this.findItemGroup(addonName.toLowerCase(Locale.ROOT), args[2]);
            if (itemGroup == null) {
                MESSAGE_FACTORY.sendMessage(sender, "commands.translation.generate.invalid-itemgroup", args[2]);
                return;
            }
            exportIds.addAll(Slimefun.getRegistry().getAllSlimefunItems().stream().filter(item -> item.getItemGroup().equals((Object)itemGroup)).map(SlimefunItem::getId).toList());
        } else {
            exportIds.addAll(Slimefun.getRegistry().getAllSlimefunItems().stream().filter(item -> item.getItemGroup().getKey().getNamespace().equals(addonName.toLowerCase(Locale.ROOT))).map(SlimefunItem::getId).toList());
        }
        String fileName = SlimefunTranslation.getTranslationService().exportItemTranslations(language, addonName, exportIds);
        MESSAGE_FACTORY.sendMessage(sender, "commands.translation.generate.success", fileName, language);
    }

    @Override
    @Nonnull
    @ParametersAreNonnullByDefault
    public List<String> onTab(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return this.getAddons(args[0]);
        }
        if (args.length == 2) {
            return this.getLanguages(args[1]);
        }
        if (args.length == 3) {
            return this.getItemGroups(args[2], args[0]);
        }
        return List.of();
    }

    @Nonnull
    private List<String> getAddons(@Nonnull String filter) {
        Set addons = Slimefun.getInstalledAddons();
        List<String> result = addons.stream().filter(addon -> addon.getName().toLowerCase(Locale.ROOT).startsWith(filter.toLowerCase(Locale.ROOT))).map(Plugin::getName).collect(Collectors.toList());
        result.add(0, "Slimefun");
        return result;
    }

    @Nonnull
    private List<String> getLanguages(@Nonnull String filter) {
        HashSet<String> result = new HashSet<String>();
        result.addAll(Slimefun.getLocalization().getLanguages().stream().map(Language::getId).toList());
        result.addAll(SlimefunTranslation.getRegistry().getLanguages());
        return result.stream().filter(lang -> lang.toLowerCase(Locale.ROOT).startsWith(filter.toLowerCase(Locale.ROOT))).toList();
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    private List<String> getItemGroups(String filter, String addon) {
        List itemGroups = Slimefun.getRegistry().getAllItemGroups();
        return itemGroups.stream().filter(itemGroup -> !(itemGroup instanceof FlexItemGroup)).map(itemGroup -> itemGroup.getKey().toString()).filter(key -> key.startsWith(addon.toLowerCase(Locale.ROOT) + ":")).filter(key -> key.toLowerCase(Locale.ROOT).startsWith(filter.toLowerCase(Locale.ROOT))).map(key -> key.split(":")[1]).toList();
    }

    @Nullable
    @ParametersAreNonnullByDefault
    private ItemGroup findItemGroup(String namespace, String key) {
        for (ItemGroup itemGroup : Slimefun.getRegistry().getAllItemGroups()) {
            NamespacedKey itemGroupKey = itemGroup.getKey();
            if (!itemGroupKey.getNamespace().equals(namespace) || !itemGroupKey.getKey().equals(key)) continue;
            return itemGroup;
        }
        return null;
    }
}

