/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.core.services;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.slimefuntranslation.SlimefunTranslation;
import net.guizhanss.slimefuntranslation.api.config.TranslationConfiguration;
import net.guizhanss.slimefuntranslation.api.events.TranslationsLoadEvent;
import net.guizhanss.slimefuntranslation.api.translation.ItemTranslation;
import net.guizhanss.slimefuntranslation.api.translation.TranslationStatus;
import net.guizhanss.slimefuntranslation.core.Registry;
import net.guizhanss.slimefuntranslation.core.services.IntegrationService;
import net.guizhanss.slimefuntranslation.core.users.User;
import net.guizhanss.slimefuntranslation.implementation.translations.ProgrammedItemTranslation;
import net.guizhanss.slimefuntranslation.utils.ColorUtils;
import net.guizhanss.slimefuntranslation.utils.FileUtils;
import net.guizhanss.slimefuntranslation.utils.SlimefunItemUtils;
import net.guizhanss.slimefuntranslation.utils.TranslationUtils;
import net.guizhanss.slimefuntranslation.utils.constant.Keys;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class TranslationService {
    private static final String FOLDER_NAME = "translations";
    private final SlimefunTranslation plugin;
    private final File translationsFolder;
    private final File jarFile;

    @ParametersAreNonnullByDefault
    public TranslationService(SlimefunTranslation plugin, File jarFile) {
        this.translationsFolder = new File(plugin.getDataFolder(), FOLDER_NAME);
        this.plugin = plugin;
        this.jarFile = jarFile;
        this.extractTranslations(false);
    }

    public void callLoadEvent() {
        Bukkit.getPluginManager().callEvent((Event)new TranslationsLoadEvent());
    }

    public void loadTranslations() {
        this.loadLanguages();
        this.loadFixedTranslations();
        this.loadProgrammedTranslations();
    }

    public void clearTranslations() {
        Registry registry = SlimefunTranslation.getRegistry();
        registry.getLanguages().clear();
        registry.getItemTranslations().clear();
        registry.getLoreTranslations().clear();
        registry.getMessageTranslations().clear();
    }

    private void loadLanguages() {
        List<String> languages = FileUtils.listFolders(this.translationsFolder);
        SlimefunTranslation.getRegistry().getLanguages().addAll(languages);
    }

    private void loadFixedTranslations() {
        for (String lang : SlimefunTranslation.getRegistry().getLanguages()) {
            this.loadFixedTranslations(lang);
        }
        for (String lang : SlimefunTranslation.getConfigService().getLanguageMappings().keySet()) {
            this.loadFixedTranslations(lang);
        }
    }

    private void loadFixedTranslations(String language) {
        File languageFolder = new File(this.translationsFolder, language);
        List<String> translationFiles = FileUtils.listYamlFiles(languageFolder);
        for (String translationFile : translationFiles) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)new File(languageFolder, translationFile));
            Optional<TranslationConfiguration> translationConfig = TranslationConfiguration.fromFileConfiguration(language, (FileConfiguration)config);
            if (translationConfig.isEmpty()) continue;
            translationConfig.get().register((SlimefunAddon)SlimefunTranslation.getInstance());
        }
    }

    private void loadProgrammedTranslations() {
        Set<String> languages = SlimefunTranslation.getRegistry().getLanguages();
        for (SlimefunItem sfItem : Slimefun.getRegistry().getAllSlimefunItems()) {
            if (!TranslationUtils.isTranslatableItem(sfItem)) continue;
            for (String lang : languages) {
                ProgrammedItemTranslation translation = new ProgrammedItemTranslation(lang, sfItem);
                Map<String, Map<String, ItemTranslation>> allItemTranslations = SlimefunTranslation.getRegistry().getItemTranslations();
                allItemTranslations.putIfAbsent(lang, new HashMap());
                Map<String, ItemTranslation> currentTranslations = allItemTranslations.get(lang);
                currentTranslations.put(sfItem.getId(), translation);
            }
        }
    }

    public void extractTranslations(boolean replace) {
        if (!this.translationsFolder.exists()) {
            this.translationsFolder.mkdirs();
        }
        List<String> translationFiles = FileUtils.listYamlFilesInJar(this.jarFile, "translations/");
        for (String translationFile : translationFiles) {
            String filePath = FOLDER_NAME + File.separator + translationFile;
            File file = new File(this.plugin.getDataFolder(), filePath);
            if (file.exists() && !replace) continue;
            this.plugin.saveResource(filePath, replace);
        }
    }

    @ParametersAreNonnullByDefault
    public String exportItemTranslations(String language, String addonName, Set<String> ids) {
        String fileName;
        File file;
        File langFolder = new File(this.translationsFolder, language);
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        int idx = 1;
        do {
            fileName = "export-" + idx + ".yml";
            file = new File(langFolder, fileName);
            ++idx;
        } while (file.exists());
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.set("name", (Object)addonName);
        for (String itemId : ids) {
            String path = "translations." + itemId;
            SlimefunItem sfItem = SlimefunItem.getById((String)itemId);
            if (sfItem == null) continue;
            config.set(path + ".name", (Object)ColorUtils.useAltCode(sfItem.getItemName()));
            ItemMeta meta = sfItem.getItem().getItemMeta();
            if (!meta.hasLore()) continue;
            config.set(path + ".lore", ColorUtils.useAltCode(meta.getLore()));
        }
        try {
            config.save(file);
        }
        catch (IOException ex) {
            SlimefunTranslation.log(Level.SEVERE, ex, "An error has occurred while exporting translation file.", new Object[0]);
        }
        return fileName;
    }

    @Nonnull
    public String getTranslatedItemName(@Nonnull User user, @Nullable SlimefunItem sfItem) {
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"user cannot be null");
        if (sfItem == null) {
            return "";
        }
        if (SlimefunTranslation.getConfigService().getDisabledItems().contains(sfItem.getId())) {
            return sfItem.getItemName();
        }
        Optional transl = TranslationUtils.findTranslation(SlimefunTranslation.getRegistry().getItemTranslations(), user, sfItem.getId());
        return transl.map(itemTranslation -> SlimefunTranslation.getIntegrationService().applyPlaceholders(user, itemTranslation.getDisplayName(user, sfItem.getItem(), sfItem.getItem().getItemMeta(), sfItem.getItemName()))).orElseGet(() -> ((SlimefunItem)sfItem).getItemName());
    }

    public boolean translateItem(@Nonnull User user, @Nullable ItemStack item) {
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"user cannot be null");
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        String sfId = SlimefunItemUtils.getId(item);
        if (sfId == null) {
            return false;
        }
        return this.translateItem(user, item, sfId);
    }

    @ParametersAreNonnullByDefault
    private boolean translateItem(User user, ItemStack item, String sfId) {
        ItemMeta meta;
        if (SlimefunTranslation.getConfigService().getDisabledItems().contains(sfId)) {
            return false;
        }
        Optional transl = TranslationUtils.findTranslation(SlimefunTranslation.getRegistry().getItemTranslations(), user, sfId);
        if (transl.isEmpty()) {
            return false;
        }
        ItemTranslation translation = (ItemTranslation)transl.get();
        TranslationStatus status = translation.canTranslate(user, item, meta = item.getItemMeta(), sfId);
        if (status == TranslationStatus.DENIED) {
            return false;
        }
        IntegrationService integrationService = SlimefunTranslation.getIntegrationService();
        String originalDisplayName = meta.hasDisplayName() ? meta.getDisplayName() : "";
        meta.setDisplayName(integrationService.applyPlaceholders(user, translation.getDisplayName(user, item, meta, originalDisplayName)));
        if (this.shouldTranslateLore(meta) && status != TranslationStatus.NAME_ONLY) {
            List originalLore = meta.hasLore() ? meta.getLore() : new ArrayList();
            meta.setLore(integrationService.applyPlaceholders(user, translation.getLore(user, item, meta, originalLore)));
        }
        item.setItemMeta(meta);
        return true;
    }

    @ParametersAreNonnullByDefault
    private boolean shouldTranslateLore(ItemMeta meta) {
        Set keys = meta.getPersistentDataContainer().getKeys();
        return !keys.contains(Keys.SEARCH_DISPLAY) && !keys.contains(Keys.AUCTION_ITEM);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public String getLore(User user, String id) {
        return this.getLore(user, id, false);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public String getLore(User user, String id, boolean defaultToId) {
        Optional transl = TranslationUtils.findTranslation(SlimefunTranslation.getRegistry().getLoreTranslations(), user, id);
        return transl.orElse(defaultToId ? id : "");
    }
}

