/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.implementation.translations;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.slimefuntranslation.SlimefunTranslation;
import net.guizhanss.slimefuntranslation.api.translation.ItemTranslation;
import net.guizhanss.slimefuntranslation.core.users.User;
import net.guizhanss.slimefuntranslation.utils.constant.Methods;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ProgrammedItemTranslation
implements ItemTranslation {
    private final String lang;
    private final SlimefunItem sfItem;
    private int errorCount = 0;

    @Override
    @Nonnull
    @ParametersAreNonnullByDefault
    public String getDisplayName(User user, ItemStack item, ItemMeta meta, String original) {
        try {
            Method method = this.sfItem.getClass().getDeclaredMethod("getTranslatedItemName", Methods.TRANSLATABLE_ITEM_GET_NAME_PARAMS);
            Object obj = method.invoke((Object)this.sfItem, user.getPlayer(), user.getLocale(), item, original);
            return (String)obj;
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.handleError(user, e);
            return original;
        }
    }

    @Override
    @Nonnull
    @ParametersAreNonnullByDefault
    public List<String> getLore(User user, ItemStack item, ItemMeta meta, List<String> original) {
        try {
            Method method = this.sfItem.getClass().getDeclaredMethod("getTranslatedItemLore", Methods.TRANSLATABLE_ITEM_GET_LORE_PARAMS);
            Object obj = method.invoke((Object)this.sfItem, user.getPlayer(), user.getLocale(), item, original);
            return (List)obj;
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.handleError(user, e);
            return original;
        }
    }

    @ParametersAreNonnullByDefault
    private void handleError(User user, Exception ex) {
        SlimefunTranslation.log(Level.SEVERE, ex, "An error has occurred while translating item " + this.sfItem.getId() + " for user " + user.getPlayer().getName() + ".Report this to the developer of addon " + this.sfItem.getAddon().getName() + ".", new Object[0]);
        if (++this.errorCount >= 5) {
            for (Map<String, ItemTranslation> idMap : SlimefunTranslation.getRegistry().getItemTranslations().values()) {
                for (Map.Entry<String, ItemTranslation> entry : idMap.entrySet()) {
                    if (!entry.getKey().equals(this.sfItem.getId())) continue;
                    idMap.remove(entry.getKey());
                }
            }
            SlimefunTranslation.log(Level.SEVERE, "Too many exceptions were thrown by item translation of " + this.sfItem.getId() + " for user " + user.getPlayer().getName() + ".Terminating translation.", new Object[0]);
        }
    }

    public ProgrammedItemTranslation(String lang, SlimefunItem sfItem) {
        this.lang = lang;
        this.sfItem = sfItem;
    }
}

