/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.core.users;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.services.localization.Language;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.UUID;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class User {
    private final Player player;
    private final UUID uuid;
    private String locale;
    private SlimefunItem recentClickedBlock;

    public User(@Nonnull Player player) {
        this.player = player;
        this.uuid = player.getUniqueId();
        this.init();
    }

    public User(@Nonnull UUID uuid) {
        this.player = Bukkit.getPlayer((UUID)uuid);
        this.uuid = uuid;
        this.init();
    }

    private void init() {
        this.updateLocale();
    }

    public void updateLocale() {
        Language lang = Slimefun.getLocalization().getLanguage(this.player);
        if (lang != null) {
            this.setLocale(lang.getId());
        } else {
            this.setLocale(Slimefun.getLocalization().getDefaultLanguage().getId());
        }
    }

    public void setLocale(@Nonnull String newLocale) {
        Preconditions.checkArgument((newLocale != null ? 1 : 0) != 0, (Object)"Locale cannot be null");
        this.locale = newLocale;
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public String getLocale() {
        return this.locale;
    }

    @Generated
    public SlimefunItem getRecentClickedBlock() {
        return this.recentClickedBlock;
    }

    @Generated
    public String toString() {
        return "User(player=" + String.valueOf(this.getPlayer()) + ", uuid=" + String.valueOf(this.getUuid()) + ", locale=" + this.getLocale() + ", recentClickedBlock=" + String.valueOf(this.getRecentClickedBlock()) + ")";
    }

    @Generated
    public void setRecentClickedBlock(SlimefunItem recentClickedBlock) {
        this.recentClickedBlock = recentClickedBlock;
    }
}

