/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.core.services;

import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.guizhanss.slimefuntranslation.SlimefunTranslation;
import net.guizhanss.slimefuntranslation.core.users.User;
import org.bukkit.entity.Player;

public final class UserService {
    @Nonnull
    public User getUser(@Nonnull UUID uuid) {
        Map<UUID, User> users = SlimefunTranslation.getRegistry().getUsers();
        if (users.containsKey(uuid)) {
            return users.get(uuid);
        }
        User user = new User(uuid);
        users.put(uuid, user);
        return user;
    }

    @Nonnull
    public User getUser(@Nonnull Player p) {
        return this.getUser(p.getUniqueId());
    }

    public void addUser(@Nonnull UUID uuid) {
        SlimefunTranslation.getRegistry().getUsers().putIfAbsent(uuid, new User(uuid));
    }

    public void addUser(@Nonnull Player p) {
        this.addUser(p.getUniqueId());
    }

    public void removeUser(@Nonnull UUID uuid) {
        SlimefunTranslation.getRegistry().getUsers().remove(uuid);
    }

    public void removeUser(@Nonnull Player p) {
        this.removeUser(p.getUniqueId());
    }
}

