/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.utils.tags;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.guizhanss.slimefuntranslation.SlimefunTranslation;
import net.guizhanss.slimefuntranslation.api.exceptions.TagMisconfigurationException;
import net.guizhanss.slimefuntranslation.utils.tags.TagParser;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;

public enum SlimefunTranslationTag implements Tag<Material>
{
    SWORD,
    HELMET,
    CHESTPLATE,
    LEGGINGS,
    BOOTS,
    HORSE_ARMOR,
    AXE,
    PICKAXE,
    SHOVEL,
    HOE,
    FISHING_ROD,
    BOW,
    HEAD,
    CARPET,
    HAND_SLOT,
    OFF_HAND_SLOT,
    HEAD_SLOT,
    CHEST_SLOT,
    LEGS_SLOT,
    FEET_SLOT;

    private static final SlimefunTranslationTag[] cachedValues;
    private static final Map<String, SlimefunTranslationTag> nameLookup;
    private final NamespacedKey key;
    private final Set<Material> materials = new HashSet<Material>();
    private final Set<Tag<Material>> additionalTags = new HashSet<Tag<Material>>();

    private SlimefunTranslationTag() {
        this.key = new NamespacedKey(SlimefunTranslation.getInstance(), this.name().toLowerCase(Locale.ROOT));
    }

    public static void reloadAll() {
        for (SlimefunTranslationTag tag : cachedValues) {
            tag.reload();
        }
    }

    @Nullable
    public static SlimefunTranslationTag getTag(@Nonnull String value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Tag cannot be null!");
        return nameLookup.get(value);
    }

    public void reload() {
        try {
            new TagParser(this).parse((materialSet, additionalTagSet) -> {
                this.materials.clear();
                this.materials.addAll((Collection<Material>)materialSet);
                this.additionalTags.clear();
                this.additionalTags.addAll((Collection<Tag<Material>>)additionalTagSet);
            });
        }
        catch (TagMisconfigurationException ex) {
            SlimefunTranslation.log(Level.SEVERE, ex, "An error has occurred while trying to load SlimefunTranslationTag: " + this.name(), new Object[0]);
        }
    }

    @Nonnull
    public NamespacedKey getKey() {
        return this.key;
    }

    public boolean isTagged(@Nonnull Material material) {
        if (this.materials.contains(material)) {
            return true;
        }
        for (Tag<Material> tag : this.additionalTags) {
            if (!tag.isTagged((Keyed)material)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public Set<Material> getValues() {
        if (this.additionalTags.isEmpty()) {
            return Collections.unmodifiableSet(this.materials);
        }
        EnumSet<Material> values = EnumSet.noneOf(Material.class);
        values.addAll(this.materials);
        for (Tag<Material> tag : this.additionalTags) {
            values.addAll(tag.getValues());
        }
        return values;
    }

    public boolean isEmpty() {
        if (!this.materials.isEmpty()) {
            return false;
        }
        return this.getValues().isEmpty();
    }

    static {
        cachedValues = SlimefunTranslationTag.values();
        nameLookup = new HashMap<String, SlimefunTranslationTag>();
        for (SlimefunTranslationTag tag : cachedValues) {
            nameLookup.put(tag.name(), tag);
        }
    }
}

