/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.utils;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.services.localization.Language;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.guizhanss.slimefuntranslation.core.users.User;
import net.guizhanss.slimefuntranslation.utils.ReflectionUtils;
import net.guizhanss.slimefuntranslation.utils.constant.Methods;

public final class TranslationUtils {
    public static final String DEFAULT_LANGUAGE = "en";

    @Nonnull
    public static <V> Optional<V> findTranslation(@Nonnull Map<String, Map<String, V>> map, @Nullable User user, @Nonnull String key) {
        V translation;
        Preconditions.checkArgument((map != null ? 1 : 0) != 0, (Object)"map cannot be null");
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key cannot be null");
        if (user == null) {
            return TranslationUtils.findDefaultTranslation(map, key);
        }
        Map<String, V> translations = map.get(user.getLocale());
        if (translations != null && (translation = translations.get(key)) != null) {
            return Optional.of(translation);
        }
        return TranslationUtils.findDefaultTranslation(map, key);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static <V> Optional<V> findDefaultTranslation(Map<String, Map<String, V>> map, String key) {
        V translation;
        Map<String, V> translations;
        Preconditions.checkArgument((map != null ? 1 : 0) != 0, (Object)"map cannot be null");
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key cannot be null");
        Language serverDefault = Slimefun.getLocalization().getDefaultLanguage();
        if (serverDefault != null && (translations = map.get(serverDefault.getId())) != null && (translation = translations.get(key)) != null) {
            return Optional.of(translation);
        }
        translations = map.get(DEFAULT_LANGUAGE);
        if (translations != null) {
            return Optional.ofNullable(translations.get(key));
        }
        return Optional.empty();
    }

    public static boolean isTranslatableItem(@Nullable SlimefunItem item) {
        if (item == null) {
            return false;
        }
        return ReflectionUtils.hasMethod(item.getClass(), "getTranslatedItemName", Methods.TRANSLATABLE_ITEM_GET_NAME_PARAMS) && ReflectionUtils.hasMethod(item.getClass(), "getTranslatedItemLore", Methods.TRANSLATABLE_ITEM_GET_LORE_PARAMS);
    }

    @Generated
    private TranslationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

