/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.utils.tags;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.CommonPatterns;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.slimefuntranslation.SlimefunTranslation;
import net.guizhanss.slimefuntranslation.api.exceptions.TagMisconfigurationException;
import net.guizhanss.slimefuntranslation.utils.constant.Patterns;
import net.guizhanss.slimefuntranslation.utils.tags.SlimefunTranslationTag;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;

class TagParser
implements Keyed {
    private final NamespacedKey key;

    TagParser(@Nonnull SlimefunTranslationTag tag) {
        this.key = tag.getKey();
    }

    public void parse(@Nonnull BiConsumer<Set<Material>, Set<Tag<Material>>> callback) throws TagMisconfigurationException {
        String path = "/tags/" + this.key.getKey() + ".json";
        EnumSet<Material> materials = EnumSet.noneOf(Material.class);
        HashSet<Tag<Material>> tags = new HashSet<Tag<Material>>();
        try {
            InputStream stream = SlimefunTranslation.class.getResourceAsStream(path);
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
            JsonObject root = new JsonParser().parse(reader).getAsJsonObject();
            JsonElement child = root.get("values");
            if (child instanceof JsonArray) {
                JsonArray values = child.getAsJsonArray();
                for (JsonElement element : values) {
                    JsonPrimitive primitive;
                    if (element instanceof JsonPrimitive && (primitive = (JsonPrimitive)element).isString()) {
                        this.parseString(element.getAsString(), materials, tags);
                        continue;
                    }
                    throw new TagMisconfigurationException(this.key, "Unexpected value format: " + element.getClass().getSimpleName() + " - " + String.valueOf(element));
                }
            } else {
                throw new TagMisconfigurationException(this.key, "No values array specified");
            }
            callback.accept(materials, tags);
        }
        catch (JsonParseException | IllegalStateException | NullPointerException x) {
            throw new TagMisconfigurationException(this.key, x);
        }
    }

    @ParametersAreNonnullByDefault
    private void parseString(String value, Set<Material> materials, Set<Tag<Material>> tags) throws TagMisconfigurationException {
        if (Patterns.MINECRAFT_NAMESPACEDKEY.matcher(value).matches()) {
            Material material = Material.matchMaterial((String)value);
            if (material != null) {
                materials.add(material);
            }
        } else if (Patterns.SFT_TAG.matcher(value).matches()) {
            String keyValue = CommonPatterns.COLON.split(value)[1].toUpperCase(Locale.ROOT);
            SlimefunTranslationTag tag = SlimefunTranslationTag.getTag(keyValue);
            if (tag != null) {
                tags.add(tag);
            } else {
                throw new TagMisconfigurationException(this.key, "SlimefunTranslationTag not exist: " + keyValue);
            }
        }
    }

    @Nonnull
    public NamespacedKey getKey() {
        return this.key;
    }
}

