/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.utils;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import net.guizhanss.slimefuntranslation.utils.constant.Keys;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;

public final class SlimefunItemUtils {
    @Nullable
    public static String getId(@Nullable ItemStack item) {
        if (item == null || item.getType().isAir() || !item.hasItemMeta()) {
            return null;
        }
        if (item instanceof SlimefunItemStack) {
            SlimefunItemStack sfItemStack = (SlimefunItemStack)item;
            return sfItemStack.getItemId();
        }
        return PersistentDataAPI.getString((PersistentDataHolder)item.getItemMeta(), (NamespacedKey)Keys.SLIMEFUN_ITEM);
    }

    @Nullable
    public static SlimefunGuideMode getGuideMode(@Nullable ItemStack item) {
        if (item == null || item.getType().isAir() || !item.hasItemMeta()) {
            return null;
        }
        String mode = PersistentDataAPI.getString((PersistentDataHolder)item.getItemMeta(), (NamespacedKey)Slimefun.getRegistry().getGuideDataKey());
        try {
            return SlimefunGuideMode.valueOf((String)mode);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return null;
        }
    }

    @Nullable
    public static String getItemGroupKey(@Nullable ItemStack item) {
        if (item == null || item.getType().isAir() || !item.hasItemMeta()) {
            return null;
        }
        return PersistentDataAPI.getString((PersistentDataHolder)item.getItemMeta(), (NamespacedKey)Keys.SLIMEFUN_ITEM_GROUP);
    }

    @Nonnull
    public static ItemStack getDisplayItem(@Nonnull ItemStack item) {
        ItemStack displayItem = item.clone();
        ItemMeta meta = displayItem.getItemMeta();
        PersistentDataAPI.setBoolean((PersistentDataHolder)meta, (NamespacedKey)Keys.SEARCH_DISPLAY, (boolean)true);
        displayItem.setItemMeta(meta);
        return displayItem;
    }

    @Generated
    private SlimefunItemUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

